/**
* @Author: caoxiukang
* @Email:caoxk@novastar.tech
* @Date: 2021/12/17 8:42
 */

package user

import (
	"fmt"
	"net/http"
	"swasocket/model"
)

type GetOnlineUsers struct {
	UserController
}

// @Title ServeHTTP
// @Description http请求 给指定用户发消息
// @Param   method  model.ReceiveMessage   消息类型
// @return code int8
// @return res string

func (m *GetOnlineUsers) ServeHTTP(resp http.ResponseWriter, req *http.Request) {

	var userIds []string
	// 返回线用户
	var returnData map[string][]string
	returnData = make(map[string][]string)
	returnData["userIds"] = userIds
	model.Clients.Range(func(key, value interface{}) bool {
		returnData["userIds"] = append(returnData["userIds"], fmt.Sprint(key))
		return true
	})
	resp.Write(m.End(0, "成功", returnData))
}
