package model

import (
	"container/list"
	"sync"
)

// 接收定义消息结构
type ReceiveMessage struct {
	// 请求的方法
	Method string `json:"method"`
	// 消息类型(1,text,0:系统消息)
	Type int8 `json:"type"`
	// 消息体
	Message string `json:"message"`
	// 消息来源用户Id
	FromId string `json:"fromId"`
	// 数据参数
	Data map[string]interface{} `json:"data"`
}

type LoginMessage struct {
	// 请求的方法
	Method string `json:"method"`
	// 消息类型(1,text,0:系统消息)
	Type int8 `json:"type"`
	// 消息体
	Message string `json:"message"`
	// 消息来源用户Id
	FromId string `json:"fromId"`
	//// 当前连接
	//Client *websocket.Conn `json:"client"`
	// 数据参数
	Data map[string]interface{} `json:"data"`
}

// SendMessage 发送消息结构
type SendMessage struct {
	// 请求的方法
	Method string `json:"method"`
	// 消息类型(1,text,0:系统消息))
	Type uint8 `json:"type"`
	// 消息体
	Message string `json:"message"`
	// Code 0 正确，1 错误
	Code int16 `json:"code"`
	// 数据参数
	Data interface{} `json:"data"`
	// 消息id
	MessageId string `json:"messageId"`
}

// Domain 域名白名单
type Domain struct {
	Host []string `json:"host"`
}

// 所有用户连接辞池子
//var Clients = make(map[string]*websocket.Conn) // connected clients

// 所有消息管道
var MessageBroadcast = make(chan ReceiveMessage) // broadcast channel

// 所有处理失败消息管道
var ErrorMessage = []ReceiveMessage{}

// 所有连接的管道尺子
var ClientsSubscribers = list.New()

// 所有连接池子
var Clients sync.Map
