package runtime

import (
	"swasocket/config"
	"swasocket/pkg/zaplogger"
)

var (
	//Trace   *log.Logger // 记录所有日志
	//Info    *log.Logger // 重要的信息
	//Warning *log.Logger // 需要注意的信息
	//Error   *log.Logger // 非常严重的问题
)

// @Title OldLog
// @Description 老版本日志操作暂时不用了

func OldLog() {
	//now := time.Now()
	//
	////时间格式化输出 Printf输出
	//fileName := fmt.Sprintf("runtime/logs/service_log_%d%d%d.log", now.Year(), now.Month(), now.Day())
	//
	//file, err := os.OpenFile(fileName, os.O_CREATE|os.O_WRONLY|os.O_APPEND, 0666)
	//if err != nil {
	//	log.Fatalln("Failed to open error log file:", err)
	//}
	//
	//Trace = log.New(io.MultiWriter(file, os.Stderr), "TRACE: ", log.Ldate|log.Ltime|log.Lshortfile)
	//
	//Info = log.New(io.MultiWriter(file, os.Stderr), "INFO: ", log.Ldate|log.Ltime|log.Lshortfile)
	//
	//Warning = log.New(io.MultiWriter(file, os.Stderr), "WARNING: ", log.Ldate|log.Ltime|log.Lshortfile)
	//
	//Error = log.New(io.MultiWriter(file, os.Stderr), "ERROR: ", log.Ldate|log.Ltime|log.Lshortfile)
}

func InitLog() {
	logc := zaplogger.LogConfig{
		Encoding:   config.LogDataEncoding,   // 日志编码格式
		Filename:   config.LogDataFilename,   // 日志文件路径
		MaxSize:    config.LogDataMaxSize,    // megabytes(兆字节)
		MaxBackups: config.LogDataMaxBackups, // 最多保留3个备份
		MaxAge:     config.LogDataMaxAge,     // days
		Compress:   config.LogDataCompress,   // 是否压缩 disabled by default
		LocalTime:  config.LogDataLocalTime,  // 用于格式化备份文件中的时间戳的时间是计算机的本地时间。 默认是使用UTC
		TimeFormat: config.LogDataTimeFormat, // 时间格式化字符串
	}
	_ = zaplogger.InitLogger(config.LogDataLevel, logc)
}
