package user

import (
	"container/list"
	"fmt"
	"github.com/gorilla/websocket"
	"swasocket/model"
	"swasocket/pkg/zaplogger"
)

type User struct {
}

func NewUserServer() *User {
	return &User{}
}

// @Title Connect
// @Description 用户链接
// @Param   message model.ReceiveMessage  用户消息
// @return   code  int16  返回码
// @return   message  string   消息

func (u *User) Connect(message model.LoginMessage, c *websocket.Conn) (code int16, res string) {
	// 1.接收到用户连接,执行登录
	var returnMessage model.SendMessage
	returnMessage.Type = 1
	returnMessage.Method = message.Method

	l := len([]rune(message.FromId))

	if l == 0 || l < 10 {
		returnMessage.Code = 10001
		returnMessage.Message = "用户信息有误"
		c.WriteJSON(returnMessage)
		return returnMessage.Code, returnMessage.Message
	}

	// 判断用户是否连接-连接后直接返回
	_, ok := model.Clients.Load(message.FromId)
	if ok {
		returnMessage.Code = 10002
		returnMessage.Message = "该用户已连接"
		c.WriteJSON(returnMessage)
		//c.WriteJSON(returnMessage)
		//conn, ok := user.(*websocket.Conn)
		//if ok {
		//	conn.Close()
		//}
		return returnMessage.Code, returnMessage.Message
	}
	// 添加用户
	model.Clients.Store(message.FromId, c)

	// 获取在id
	var userIds []string
	// 返回线用户
	var returnData map[string][]string
	var onLineNumber int
	returnData = make(map[string][]string)
	returnData["userIds"] = userIds
	model.Clients.Range(func(key, value interface{}) bool {
		returnData["userIds"] = append(returnData["userIds"], fmt.Sprint(key))
		onLineNumber++
		return true
	})

	returnMessage.Code = 10000
	returnMessage.Message = "连接成功"
	// 获取所有在线用户列表
	returnMessage.Data = onLineNumber
	c.WriteJSON(returnMessage)
	return 0, returnMessage.Message
}

// @Title Connect
// @Description 用户链接
// @Param   message model.ReceiveMessage  用户消息
// @return   code  int16  返回码
// @return   message  string   消息

func (u *User) LoginOut(message model.LoginMessage) {
	zaplogger.Info("LoginOut after:", message.FromId)
	model.Clients.Delete(message.FromId)
	// 二次确认
	_, ok := model.Clients.Load(message.FromId)
	if ok {
		model.Clients.Delete(message.FromId)
		zaplogger.Info("LoginOut after one delete:", message.FromId)
	}
}

// @Description:  判断用户是否存在
// @param subscribers *list.List
// @param fromId string
// @return bool

func isUserExist(subscribers *list.List, fromId string) bool {
	//for sub := subscribers.Front(); sub != nil; sub = sub.Next() {
	//	if sub.Value.(model.User).FromId == fromId {
	//		return true
	//	}
	//}
	return false
}
