<?php

namespace App\Http\Controllers\Console;

use App\Http\Controllers\Controller;
use App\Models\SystemLog;
use App\Services\AccountService;
use App\Services\CloudService;
use App\Services\MSService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Artisan;

class ServerController extends Controller
{

    public function HttpRequest($server,$segment1='',$segment2=""){
        global $_W, $_GPC;
        $_W['server'] = trim($server);
        $_W['inService'] = true;
        $_W['basescript'] = "server";
        if (!function_exists('tpl_compile') && defined("IN_SYS")){
            include_once app_path("Helpers/smarty.php");
        }
        $service = serv($_W['server']);
        if (!method_exists($service, 'initServer')){
            return $this->message($service->error);
        }
        $ctrl = trim($segment1);
        if (!empty($segment2)){
            $ctrl = implode("/", array($ctrl, trim($segment2)));
        }
        if ($service->Unique && empty($_W['uniacid'])){
            if (!empty($_GPC['i'])){
                $_W['uniacid'] = intval($_GPC['i']);
            }
            if (!empty($_GPC['uniacid'])){
                $_W['uniacid'] = intval($_GPC['uniacid']);
            }
            if (empty($_W['uniacid'])){
                return $this->checkout($service->url($ctrl));
            }
            $service->uniacid = $_W['uniacid'];
            session()->put('uniacid',$_W['uniacid']);
        }
        $data = $service->HttpRequest('web', $ctrl);
        if (is_error($data)){
            return $this->message($data['message']);
        }
        if (!is_array($data)){
            return $data;
        }
        if (isset($data['message']) && isset($data['type'])){
            return $this->message($data["message"], $data['redirect'], $data['type']);
        }
        return $this->globalView("server.".str_replace("/",".", $ctrl),$data);
    }

    public function checkout($refresh=''){
        global $_GPC, $_W;
        if (!empty($_GPC['uniacid'])){
            if (empty($refresh)){
                $refresh = referer();
            }
            session()->put('uniacid',intval($_GPC['uniacid']));
            $refresh = preg_replace('/[\?|\&]uniacid=[\d]+/', "", $refresh);
            header("location:$refresh");
            session_exit();
        }
        $data = array(
            'refresh'=>$refresh,
            'uniacid'=>intval($_W['uniacid']),
            'platforms'=>AccountService::OwnerAccounts(array(), -1, true)
        );
        return $this->globalView("console.server.platform",$data);
    }

    public function TerminalError($message){
        MSService::TerminalSend(["mode"=>"err", "message"=>$message], true);
        return $this->message($message);
    }

    public function index(Request $request){
        global $_W;
        if (empty($_W['config']['site']['id'])){
            return redirect("console/active");
        }
        $_W['inSetting'] = true;
        $startTime = time();
        $op = $request->input("op","index");
        $identity = $request->input("nid", "");
        $return = array("title"=>__('服务管理'), "op"=>$op);
        $MSS = new MSService();
        switch ($op){
            case "stop" : {
                $return['title'] .= " - ". __('已停用');
                $return['servers'] = MSService::InitService(0);
                break;
            }
            case "local" : {
                $return['title'] .= " - ". __('moreServices');
                $return['servers'] = MSService::getlocal();
                $cloudServers = MSService::cloudServers();
                if (!empty($cloudServers)){
                    $return['servers'] = array_merge($cloudServers, $return['servers']);
                }
                $return['needServer'] = $request->input('need', '');
                break;
            }
            case "repair" : {
                try {
                    Artisan::call('self:repair');
                    SystemLog::userOperation('修复系统服务', 'server:repair', '系统服务修复');
                }catch (\Exception $exception){
                    SystemLog::systemRunning(
                        '修复系统服务异常',
                        'server:repair',
                        "修复系统服务过程中发生异常：{$exception->getMessage()}",
                        false,
                        [
                            'exception_file' => $exception->getFile(),
                            'exception_line' => $exception->getLine(),
                            'exception_code' => $exception->getCode(),
                            'exception_trace' => $exception->getTrace()
                        ]
                    );
                    return $this->message($exception->getMessage());
                }
                return $this->message("successful", wurl("server"), "success");
            }
            case "install" : {
                $res = $MSS->install($identity);
                $status = !is_error($res);
                SystemLog::userOperation('安装微服务', 'server:install', "服务：{$identity}", $status, ['identity' => $identity]);
                if (!$status){
                    return $this->TerminalError($res['message']);
                }
                $stopTime = time();
                $MSS->TerminalSend(["mode"=>"success", "message"=>"安装成功！总耗时".($stopTime-$startTime)."秒"], true);
                return $this->message("installSuccessfully", wurl("server"), "success");
            }
            case "uninstall" :{
                $res = $MSS->uninstall($identity);
                $status = !is_error($res);
                SystemLog::userOperation('卸载微服务', 'server:uninstall', "服务：{$identity}", $status, ['identity' => $identity]);
                if (!$status){
                    return $this->TerminalError($res['message']);
                }
                $MSS->TerminalSend(["mode"=>"success", "message"=>"服务卸载完成！"], true);
                return $this->message('uninstallComplete',wurl("server"),'success');
            }
            case "composer" : {
                $composer = MICRO_SERVER.$identity."/composer.json";
                if (!file_exists($composer)){
                    $MSS->TerminalSend(["mode"=>"success", "message"=>"安装成功！"], true);
                    return $this->message("installSuccessfully", wurl("server"), "success");
                }
                $MSS::TerminalSend(["mode"=>"info", "message"=>"即将安装Composer依赖【microserver/{$identity}】"]);
                $res = $MSS::ComposerRequire(MICRO_SERVER.$identity."/", "microserver/".$identity);
                if (is_error($res)){
                    return $this->TerminalError($res['message']);
                }
                if (!$res){
                    $requireName = "microserver/".$identity;
                    $WorkingDirectory = base_path()."/";
                    if (DEVELOPMENT){
                        $WorkingDirectory = str_replace("\\", "/", MICRO_SERVER.$identity."/");
                    }
                    $composerErr = MICRO_SERVER.$identity."/composer.error";
                    if (!file_exists($composerErr)){
                        $composerErr = "";
                    }
                    $composerNext = __('installVendorNext');
                    $MSS::ComposerPage(array(
                        'composerVer'=>"",
                        'composerErr'=>$composerErr,
                        'WorkingDirectory'=>$WorkingDirectory,
                        'requireName'=>$requireName,
                        'composerNext'=>$composerNext
                    ));
                }
                @unlink(MICRO_SERVER.$identity."/composer.error");
                $MSS->TerminalSend(["mode"=>"success", "message"=>"Composer安装完成"], true);
                return $this->message("installSuccessfully", wurl("server"), "success");
            }
            case "disable" : {
                $result = MSService::disable($identity);
                SystemLog::userOperation('停用微服务', 'server:disable', "服务：{$identity}", $result, ['identity' => $identity]);
                if ($result){
                    return $this->success('successful',wurl("server"));
                }
                return $this->message();
            }
            case "upgrade" : {
                $res = $MSS->upgrade($identity);
                $status = !is_error($res);
                SystemLog::userOperation('升级微服务', 'server:upgrade', "服务：{$identity}", $status, ['identity' => $identity]);
                if (!$status){
                    return $this->TerminalError($res['message']);
                }
                $stopTime = time();
                $MSS->TerminalSend(["mode"=>"success", "message"=>"升级成功！总耗时".($stopTime-$startTime)."秒"], true);
                return $this->message("upgradeSuccessfully", wurl("server"), "success");
            }
            case "cloudup" : {
                $res = $MSS->cloudUpdate($identity);
                $status = !is_error($res);
                SystemLog::userOperation('升级微服务', 'server:cloudup', "服务：{$identity}（云端升级）", $status, ['identity' => $identity]);
                if (!$status){
                    return $this->TerminalError($res['message']);
                }
                $stopTime = time();
                $MSS->TerminalSend(["mode"=>"success", "message"=>"升级成功！总耗时".($stopTime-$startTime)."秒"], true);
                return $this->message("upgradeSuccessfully", wurl("server"), "success");
            }
            case "cloudInstall" : {
                $res = $MSS->cloudInstall($identity);
                $status = !is_error($res);
                SystemLog::userOperation('安装微服务', 'server:cloudInstall', "服务：{$identity}（云端安装）", $status, ['identity' => $identity]);
                if (!$status){
                    return $this->TerminalError($res['message']);
                }
                $stopTime = time();
                $MSS->TerminalSend(["mode"=>"success", "message"=>"安装成功！总耗时".($stopTime-$startTime)."秒"], true);
                return $this->message("installSuccessfully", wurl("server"), "success");
            }
            case "restore" : {
                $result = MSService::restore($identity);
                SystemLog::userOperation('恢复微服务', 'server:restore', "服务：{$identity}", $result, ['identity' => $identity]);
                if ($result){
                    return $this->message('successful',wurl("server", array('op'=>'stop')),'success');
                }
                return $this->message();
            }
            case "cloudChk" : {
                $cloudServer = $MSS->cloudServer($identity, true);
                if (!is_error($cloudServer)){
                    $service = $MSS::getone($identity);
                    $release = $cloudServer['release'];
                    if (version_compare($release['version'], $service['version'], '>') || $release['releasedate']>$service['releases']){
                        return $this->message(['release'=>$release], "", "success");
                    }
                }
                return $this->message();
            }
            default : {
                $return['op'] = "index";
                $return['servers'] = MSService::InitService();
            }
        }
        $swaSocket = serv('websocket');
        global $_W;
        $return['socket'] = [
            'server'=>"wss://socket.whotalk.com.cn/wss",
            'userSign'=>md5($_W['config']['setting']['authkey'].":terminal:{$_W['uid']}"),
            'userId'=>$_W['uid']
        ];
        if ($swaSocket->enabled){
            $return['socket']['server'] = $swaSocket->settings['server'];
        }
        $return['activeState'] = CloudService::CloudActive(true);
        return $this->globalView("console.server", $return);
    }

    public function Methods($server=""){
        $server = serv($server);
        $methods = $server->getMethods();
        if (is_error($methods)) return $this->message($methods['message'],"","error");
        if (!empty($methods['wiki']) && count($methods)==1){
            return redirect($methods['wiki']);
        }
        $wiki = $methods['wiki'];
        unset($methods['wiki']);
        $service = $server->service;
        return $this->globalView("console.server.method", array(
            'title'=>$service['name'],
            'service'=>$service,
            'classname' => ucfirst($service['identity']),
            'wiki'=>$wiki,
            'methods'=>$methods
        ));
    }

    public function Apis($server=""){
        $service = serv($server);
        $apis = $service->getApis();
        if(empty($apis['schemas'])){
            if (!empty($apis['wiki'])){
                return redirect($apis['wiki']);
            }else{
                return $this->message("serviceWithoutApis");
            }
        }
        return $this->globalView("console.server.api", array(
            'title'=>$service->service['name'],
            'schemas'=>$apis['schemas']
        ));
    }

}
