<?php

use Illuminate\Support\Facades\Schema;

$versionCode = QingRelease;
if ($versionCode<2023100502){
    throw new Exception(__("lang.系统版本过低"));
}

if (file_exists(MICRO_SERVER . "language/lang.zip")){
    $zip = new \ZipArchive();
    $openRes = $zip->open(MICRO_SERVER . "language/lang.zip");
    if ($openRes === TRUE) {
        $zip->extractTo(resource_path("lang/"));
        $zip->close();
    }else{
        throw new Exception("Resource package decompression failed.");
    }
}

$setupSql = "";
if (!Schema::hasTable('languages')){
    $languages = tablename('languages');
    $setupSql = <<<EOF
CREATE TABLE $languages (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL DEFAULT '',
  `code` varchar(10) NOT NULL DEFAULT '',
  `country` varchar(50) NOT NULL DEFAULT '',
  `status` tinyint(1) UNSIGNED NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY( `code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
EOF;
    $setupSql .= "INSERT INTO $languages ( `name`, `code`, `country`) VALUES ('简体中文', 'zh', '中国大陆');";
    $setupSql .= "INSERT INTO $languages ( `name`, `code`, `country`) VALUES ('English', 'en', 'England');";
}
if (!empty($setupSql)){
    pdo_query($setupSql);
}
$finish = true;
