@include('console.server.header')
<div class="layui-fluid">
    <div class="main-content fui-content">
        <h2>@lang('lang.languagePackage')</h2>
        <div class="layui-tab fui-tab margin-bottom-xl">
            <ul class="layui-tab-title title_tab">
                <li>
                    <a href="{{ $inService->url() }}">@lang('lang.languagePackage')</a>
                </li>
                <li>
                    <a href="{{ $inService->url('locales') }}">@lang('lang.languages')</a>
                </li>
                <li class="layui-this">
                    <a href="javascript:">{{ $title }}</a>
                </li>
            </ul>
        </div>

        <div class="fui-card layui-card">
            <div class="layui-card-body">
                <form class="layui-form" method="post" action="{{ $inService->url('save') }}" lay-filter="component-form-element">
                    <input type="hidden" name="_token" value="{{ $_W['token'] }}" />
                    <div class="layui-form-item must">
                        <label class="layui-form-label">@lang('lang.languagePackage')&nbsp;ID</label>
                        <div class="layui-input-block">
                            <input type="text" name="packageID" onblur="langChk(this)" value="{{ $id }}" lay-verify="required" placeholder="@lang('lang.packageIDPlaceholder')" autocomplete="off" class="layui-input" />
                        </div>
                    </div>
                    <div class="layui-form-item must">
                        <label class="layui-form-label">{{ __('nameOfData', array('data'=>__('lang.languagePackage'))) }}</label>
                        <div class="layui-input-block">
                            <input type="text" name="packageName" value="" lay-verify="required" placeholder="@lang('lang.packageNamePlaceholder')" autocomplete="off" class="layui-input" />
                        </div>
                    </div>
                    <div class="layui-form-item must">
                        <label class="layui-form-label">@lang('lang.locale')</label>
                        <div class="layui-input-block">
                            <select class="layui-select" name="locale" required lay-verify="required">
                                <option value="">@lang('lang.chooseLanguage')</option>
                                @foreach($languages as $key=>$value)
                                    <option value="{{ $key }}" @if($locale==$key) disabled @endif>{{ $value['country'] }}-{{ $value['name'] }}</option>
                                @endforeach
                            </select>
                            <div class="layui-word-aux"><a href="{{ $inService->url("locales/post") }}" class="text-blue ajaxshow">{{ __('newData', array('data'=>__('lang.locale'))) }}</a></div>
                        </div>
                    </div>
                    <div class="layui-form-item must">
                        <label class="layui-form-label">@lang('lang.entries')</label>
                        @foreach($data as $key=>$value)
                            <div class="layui-input-block">
                                <div class="input-group">
                                    <span class="input-group-addon">{{ $key }}</span>
                                    <input type="text" name="data[{{$key}}]" value="{{ $value }}" required lay-verify="required" autocomplete="off" class="layui-input" />
                                </div>
                                @if(preg_match('/:(\w+)/', $value))
                                    <div class="layui-word-aux">@lang('lang.variableNotice')</div>
                                @endif
                            </div>
                        @endforeach
                        @if($id!='framework')
                        <div class="layui-input-block moreLang">
                            <a href="javascript:;" onclick="AddLang()" class="layui-btn layui-btn-xs layui-btn-fluid">+@lang('lang.newEntry')</a>
                        </div>
                        @endif
                    </div>
                    <div class="layui-form-item">
                        <div class="layui-input-block">
                            <button class="layui-btn layui-btn-normal" lay-submit type="submit" value="true" name="savedata">@lang('save')</button>
                            <button type="reset" class="layui-btn layui-btn-primary">@lang('reset')</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
    function AddLang() {
        let html = '<div class="layui-input-block">' +
            '<div class="input-group"><span class="input-group-addon">@lang('lang.entryName')</span>' +
            '<input type="text" name="names[]" value="" required lay-verify="required" placeholder="@lang('lang.typeEntryName')" autocomplete="off" class="layui-input">'+
            '<span class="input-group-addon">@lang('lang.entryText')</span><input type="text" name="values[]" value="" required lay-verify="required" placeholder="@lang('lang.typeEntryText')" autocomplete="off" class="layui-input"><span class="input-group-addon rmLang" onclick="rmLang(this)"><i class="layui-icon layui-icon-close-fill"></i></span></div></div>';
        $('.moreLang').before(html);
    }
    function rmLang(Elem) {
        $(Elem).parent().parent().remove();
    }
    function langChk(Elem) {
        let name = $(Elem).val();
        if(!name.match(/^([a-zA-Z])(\w+?)$/) && name!==''){
            layer.msg("{{ __('lang.packageIDPlaceholder') }}", {icon:2});
            $(Elem).focus();
        }
    }
</script>
<style>
    .layui-input-block + .layui-input-block{margin-top: 5px;}
    .code-inline{background-color: #eee; border:1px solid #ccc; display: inline-block; border-radius: 5px; padding: 0px 10px; height: 20px; line-height: 20px;}
    .margin-lr-xs{margin-left: 5px; margin-right: 5px;}
    .rmLang{cursor: pointer; padding: 5px 10px !important;}
    .rmLang .layui-icon{font-size: 24px; color: #e54d42;}
</style>
@include('common.footer')
