@include('console.server.header')
<div class="layui-fluid">
    <div class="main-content fui-content">
        <h2>
            <span class="pull-right"><a class="layui-btn ajaxshow" href="{{ $inService->url('locales') }}">@lang('lang.languages')</a></span>
            @lang('lang.languagePackage')
        </h2>
        <div class="layui-tab fui-tab margin-bottom-xl">
            <ul class="layui-tab-title title_tab">
                @foreach($languages as $key=>$value)
                    <li @if($key==$lang)class="layui-this"@endif>
                        <a href="{{ $inService->url('', ['lang'=>$key]) }}">{{ $value['name'] }}</a>
                    </li>
                @endforeach
            </ul>
        </div>

        <div class="fui-card layui-card">
            <div class="layui-card-header nobd">
                <a href="{{ $inService->url('post', ['lang'=>$lang]) }}" class="layui-btn layui-btn-normal fr layui-hide-xs">{{ __('newData', array('data'=>__('lang.languagePackage'))) }}</a>
                <span class="title">{{ $title }}</span>
            </div>
            <div class="layui-card-body">
                <table class="layui-table" lay-skin="nob" lay-even>
                    <thead>
                    <tr>
                        <th>@lang('name')</th>
                        <th class="layui-hide-xs">ID</th>
                        <th class="layui-hide-xs">@lang('language')</th>
                        <th class="text-right">@lang('action')</th>
                    </tr>
                    </thead>
                    <tbody>
                        @if(empty($packages))
                        @else
                            @foreach($packages as $key=>$value)
                                <tr>
                                    <td>
                                        <a href="{{ $inService->url('post', array('lang'=>$lang, 'id'=>$value['id'])) }}" class="text-blue">{{ $value['name'] }}</a>
                                        @if($value['id']=='framework')&nbsp;<span class="layui-badge layui-bg-green">@lang('lang.systemLanguage')</span>@endif
                                    </td>
                                    <td class="layui-hide-xs">{{ $value['id'] }}</td>
                                    <td class="layui-hide-xs">{{ $languages[$lang]['name'] }}</td>
                                    <td class="text-right">
                                        <a href="{{ $inService->url('copy', array('lang'=>$lang.'.'.$value['id'])) }}" class="text-blue layui-hide-xs">@lang('copy')</a>
                                        &nbsp;<a href="javascript:" data-url="{{ $inService->api('', array('locale'=>$lang, 'id'=>$value['id'])) }}" class="text-green js-clip layui-hide-xs">@lang('接口')</a>
                                        @if($value['id']!='framework')
                                            &nbsp;<a href="{{ $inService->url('post', array('lang'=>$lang, 'id'=>$value['id'])) }}" class="text-blue layui-hide-xs">@lang('edit')</a>
                                            &nbsp;<a href="{{ $inService->url('remove', array('lang'=>$lang, 'id'=>$value['id'])) }}" class="text-red confirm" data-text="@lang('deleteConfirm')">@lang('delete')</a>
                                        @endif
                                    </td>
                                </tr>
                            @endforeach
                        @endif
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@include('common.footer')
