@include('console.server.header')
<div class="layui-fluid unpadding">
    <div class="main-content fui-content">
        @if(empty($_W['isajax']))
        <h2>@lang('lang.languages')</h2>
        <div class="layui-tab fui-tab margin-bottom-xl">
            <ul class="layui-tab-title title_tab">
                <li>
                    <a href="{{ $inService->url() }}">@lang('lang.languagePackage')</a>
                </li>
                <li class="layui-this">
                    <a href="{{ $inService->url('locales') }}">@lang('lang.languages')</a>
                </li>
            </ul>
        </div>
        @endif

        <div class="fui-card layui-card">
            <div class="layui-card-header nobd">
                <a href="{{ $inService->url('locales.post') }}" class="layui-btn layui-btn-normal fr">{{ __('newData', array('data'=>__('lang.locale'))) }}</a>
                @if(empty($_W['isajax']))
                <span class="title">{{ $title }}</span>
                @endif
            </div>
            <div class="layui-card-body">
                <table class="layui-table" lay-skin="nob" lay-even>
                    <thead>
                    <tr>
                        <th>@lang('name')</th>
                        <th class="layui-hide-xs">ID</th>
                        <th class="layui-hide-xs">@lang('lang.locale')</th>
                        <th class="text-right">@lang('action')</th>
                    </tr>
                    </thead>
                    <tbody>
                        @foreach($languages as $key=>$value)
                            <tr>
                                <td>
                                    {{ $value['name'] }}
                                    @if($value['code']==$locale)
                                        &nbsp;<span class="layui-badge layui-bg-green">@lang('default')</span>
                                    @endif
                                    @if(!$value['status'])
                                        &nbsp;<span class="layui-badge layui-bg-black">@lang('terminated')</span>
                                    @endif
                                </td>
                                <td class="layui-hide-xs">{{ $value['code'] }}</td>
                                <td class="layui-hide-xs">{{ $value['country'] }}</td>
                                <td class="text-right">
                                    <a href="{!! $inService->url('locales/post', array('id'=>$value['code'])) !!}" class="text-blue ajaxshow">@lang('edit')</a>
                                    @if($value['status'] && $value['code']!=$locale)&nbsp;<a href="{!! $inService->url('locales/setup', array('id'=>$value['code'])) !!}" class="text-green confirm" data-text="@lang('lang.setDefault')">@lang('设为默认')</a>@endif
                                    @if(!$systemLocales[$value['code']])&nbsp;<a href="{!! $inService->url('locales/remove', array('id'=>$value['code'])) !!}" class="text-red confirm" data-text="@lang('deleteConfirm')">@lang('delete')</a>@endif
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@include('common.footer')
