@include('console.server.header')
<div class="layui-fluid">
    <div class="main-content fui-content">
        <div class="fui-card layui-card">
            <div class="layui-card-header">
                <span class="title">{{ $title }}</span>&nbsp;&nbsp;<a class="layui-btn layui-btn-sm" href="{{ referer() }}">@lang('back')</a>
            </div>
            <div class="layui-card-body">
                <form class="layui-form" method="post" action="{{ $inService->url('save') }}" lay-filter="component-form-element">
                    <input type="hidden" name="_token" value="{{ $_W['token'] }}" />
                    <div class="layui-form-item must">
                        <label class="layui-form-label">ID</label>
                        <div class="layui-input-block">
                            <input type="text" name="packageID" onblur="langChk(this)" value="{{ $id }}"{{ $id ? ' readonly' : '' }} lay-verify="required" placeholder="@lang('lang.packageIDPlaceholder')" autocomplete="off" class="layui-input{{ $id ? ' layui-bg-gray':'' }}" />
                        </div>
                    </div>
                    <div class="layui-form-item must">
                        <label class="layui-form-label">{{ __('nameOfData', array('data'=>__('lang.languagePackage'))) }}</label>
                        <div class="layui-input-block">
                            <input type="text" name="packageName" value="{{ $packageName }}" lay-verify="required" placeholder="@lang('lang.packageNamePlaceholder')" autocomplete="off" class="layui-input" />
                        </div>
                    </div>
                    <div class="layui-form-item must">
                        <label class="layui-form-label">@lang('lang.locale')</label>
                        <div class="layui-input-block">
                            @if($id && $locale)
                                <input type="hidden" name="locale" value="{{ $locale }}" />
                                <input type="text" name="localeName" value="{{ $languages[$locale]['country'] }} > {{ $languages[$locale]['name'] }}" readonly autocomplete="off" class="layui-input layui-bg-gray" />
                            @else
                            <select class="layui-select" name="locale" required lay-verify="required">
                                <option value="">@lang('lang.chooseLanguage')</option>
                                @foreach($languages as $key=>$value)
                                    <option value="{{ $key }}" @if($locale==$key) selected @endif>{{ $value['country'] }}-{{ $value['name'] }}</option>
                                @endforeach
                            </select>
                            @endif
                        </div>
                    </div>
                    <div class="layui-form-item must">
                        <label class="layui-form-label">@lang('lang.entries')</label>
                        @foreach($data as $key=>$value)
                            <div class="layui-input-block">
                                <div class="input-group">
                                    <span class="input-group-addon">{{ $key }}</span>
                                    <input type="text" name="data[{{$key}}]" value="{{ $value }}" required lay-verify="required" autocomplete="off" class="layui-input" />
                                </div>
                                @if(preg_match('/:(\w+)/', $value))
                                    <div class="layui-word-aux">@lang('lang.variableNotice')</div>
                                @endif
                            </div>
                        @endforeach
                        @if(empty($data))
                            <div class="layui-input-block">
                                <div class="input-group">
                                    <span class="input-group-addon">@lang('lang.entryName')</span>
                                    <input type="text" name="names[]" value="" required lay-verify="required" placeholder="@lang('lang.typeEntryName')" autocomplete="off" class="layui-input">
                                    <span class="input-group-addon">@lang('lang.entryText')</span>
                                    <input type="text" name="values[]" value="" required lay-verify="required" placeholder="@lang('lang.typeEntryText')" autocomplete="off" class="layui-input">
                                </div>
                            </div>
                        @endif
                        <div class="layui-input-block moreLang">
                            <a href="javascript:;" onclick="AddLang()" class="layui-btn layui-btn-xs layui-btn-fluid">+@lang('lang.newEntry')</a>
                        </div>
                    </div>
                    <div class="layui-form-item">
                        <div class="layui-input-block">
                            <button class="layui-btn layui-btn-normal" lay-submit type="submit" value="true" name="savedata">@lang('save')</button>
                            <button type="reset" class="layui-btn layui-btn-primary">@lang('reset')</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
    function AddLang() {
        let html = '<div class="layui-input-block">' +
            '<div class="input-group"><span class="input-group-addon">@lang('lang.entryName')</span>' +
            '<input type="text" name="names[]" value="" required lay-verify="required" placeholder="@lang('lang.typeEntryName')" autocomplete="off" class="layui-input">'+
            '<span class="input-group-addon">@lang('lang.entryText')</span><input type="text" name="values[]" value="" required lay-verify="required" placeholder="@lang('lang.typeEntryText')" autocomplete="off" class="layui-input"><span class="input-group-addon rmLang" onclick="rmLang(this)"><i class="layui-icon layui-icon-close-fill"></i></span></div></div>';
        $('.moreLang').before(html);
    }
    function rmLang(Elem) {
        $(Elem).parent().parent().remove();
    }
    function langChk(Elem) {
        let name = $(Elem).val();
        if(!name.match(/^([a-zA-Z])(\w+?)$/) && name!==''){
            layer.msg("{{ __('lang.packageIDPlaceholder') }}", {icon:2});
            $(Elem).focus();
        }
    }
</script>
<style>
    .layui-input-block + .layui-input-block{margin-top: 5px;}
    .code-inline{background-color: #eee; border:1px solid #ccc; display: inline-block; border-radius: 5px; padding: 0 10px; height: 20px; line-height: 20px;}
    .margin-lr-xs{margin-left: 5px; margin-right: 5px;}
    .rmLang{cursor: pointer; padding: 5px 10px !important;}
    .rmLang .layui-icon{font-size: 24px; color: #e54d42;}
</style>
@include('common.footer')
