<?php

namespace Server\language\web;

use Server\language\LanguageService;

class IndexController extends LanguageService {

    public function main(){
        global $_W;
        $curLang = request()->input('lang', $_W['locale']);
        $languages = $this->getLanguages();
        return $this->View(array(
            'title'=>__('lang.languagePackage'),
            'packages'=>$this->langScan($curLang),
            'lang'=>$curLang,
            'langName'=>$languages[$curLang]['name'],
            'languages'=>$languages
        ));
    }

    public function checkout(){
        global $_GPC, $_W;
        $locale = trim($_GPC['locale']);
        if ($_W['ispost'] && $locale){
            if ($locale==$_W['locale']) return $this->success("OK", referer());
            if (!$_W['setting']['languages'][$locale]){
                return $this->message('lang.invalidLocale');
            }
            session()->put("FRAME_LOCALE", $locale);
            return $this->success("OK", referer());
        }
        return $this->message('operationFailed');
    }

    public function copy(){
        global $_GPC;
        list($locale, $id) = explode(".", trim($_GPC['lang']));
        if (empty($locale) || empty($id)) return $this->message("lang.invalidPackage");
        return $this->View(array(
            'title'=>__('newData', array('data'=>__('lang.languagePackage'))),
            'data'=>$this->langGet($locale, $id),
            'languages'=>$this->getLanguages(),
            'locale'=>$locale,
            'id'=>$id,
            'localeCur'=>request()->input('locale', $this->appLocale)
        ));
    }

    public function post(){
        global $_GPC;
        $locale = request()->input('lang', $this->appLocale);
        $id = trim($_GPC['id']);
        $data = [];
        $packageName = '';
        if (!empty($id)){
            if ($id=='framework' && in_array($locale, ['en', 'zh'])){
                return $this->message('lang.系统语言包不可修改');
            }
            $data = $this->langGet($locale, $id, true);
            if (empty($data)){
                return $this->message(__('lang.packageNotFound', array('lang'=>"$locale:$id")));
            }else{
                $packageName = $data['packageName'];
                unset($data['packageName'], $data['packageID']);
                if($id=='framework'){
                    $packageName = $data['languageName'];
                    unset($data['languageName'], $data['languageID']);
                }
            }
        }
        return $this->View(array(
            'title'=>$data?__('modifyData', array('data'=>__('lang.languagePackage'))):__('newData', array('data'=>__('lang.languagePackage'))),
            'data'=>$data,
            'locale'=>$locale,
            'id'=>$id,
            'packageName'=>$packageName,
            'languages'=>$this->getLanguages()
        ));
    }

    public function remove(){
        $locale = request()->input('lang');
        $id = request()->input('id');
        if (empty($locale)) return $this->message('lang.invalidLocaleId');
        if (empty($id)) return $this->message('lang.invalidPackageId');
        if ($id=='framework' || ($id=='lang' && $this->systemLocales[$locale])) $this->message('lang.removeFramePack');
        $path = resource_path("lang/$locale/$id.php");
        if (file_exists($path)){
            @unlink($path);
        }
        return $this->success('deleteSuccessfully', referer());
    }

    public function save(){
        global $_GPC;
        $packageID = trim($_GPC['packageID']);
        if (empty($packageID) || !preg_match('/^([a-zA-Z])(\w+?)$/', $packageID)) return $this->message("lang.invalidPackageId");
        $locale = trim($_GPC['locale']);
        if (empty($locale)) return $this->message("chooseLanguage");
        if ($locale=='framework' && in_array($packageID, ['en', 'zh'])){
            return $this->message('lang.系统语言包不可修改');
        }
        $data = request()->input('data', []);
        if (!empty($_GPC['names'])){
            foreach ($_GPC['names'] as $key=>$value){
                $name = trim($value);
                if (empty($name)){
                    continue;
                }
                $text = trim($_GPC['values'][$key]);
                if (empty($text)) continue;
                $data[$name] = $text;
            }
        }
        $res = $this->langSave($packageID, trim($_GPC['packageName']), $locale, $data);
        if (is_error($res)) return $res;
        return $this->success("savedSuccessfully", $this->url('post', array('id'=>$packageID, 'lang'=>$locale)));
    }

}
