<?php

namespace Server\payment\app;

use Server\payment\PaymentService;

class CreditController extends PaymentService {
    public function main(){
        $payLog = $this->queryBuild();
        if (empty($payLog)) return $this->message("找不到该支付记录");
        if ($payLog['status']==1){
            try {
                return $this->payResult($payLog['tid'], 'return');
            }catch (\Exception $e){
                \Log::error($e->getMessage());
                return $this->message("支付成功！", '', 'success');
            }
        }
        global $_W;
        if (empty($_W['member']['uid'])){
            return $this->message("请先登录！");
        }
        pdo_update($this->tablePayLog, array('type'=>'credit'), array('plid'=>$payLog['plid']));

        $res = serv('ucenter')->UpdateCredit($_W['member']['uid'], 'credit2', 0-$payLog['fee'], ['remark'=>$payLog['tag']]);

        if (is_error($res)){
            return $this->message($res['message']);
        }

        try {
            $this->Notify('credit', array(
                'out_trade_no'=>$payLog['uniontid']
            ));

            return $this->payResult($payLog['tid'], 'return');

        }catch (\Exception $e){
            return $this->message($e->getMessage());
        }

    }

}
