<?php

use App\Services\FileService;

$setupSql = "";
if (!pdo_tableexists("core_paylog")){
    $table_paylog = tablename('core_paylog');
    $setupSql .= <<<EOF
CREATE TABLE $table_paylog (
  `plid` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `uniacid` int(11) NOT NULL,
  `acid` int(11) NOT NULL,
  `openid` varchar(40) NOT NULL,
  `uniontid` varchar(64) NOT NULL,
  `tid` varchar(128) NOT NULL,
  `fee` decimal(10,2) NOT NULL,
  `status` tinyint(1) NOT NULL,
  `module` varchar(50) NOT NULL,
  `tag` varchar(2000) NOT NULL,
  `is_usecard` tinyint(1) NOT NULL,
  `card_type` tinyint(1) NOT NULL,
  `card_id` varchar(50) NOT NULL,
  `card_fee` decimal(10,2) UNSIGNED NOT NULL,
  `encrypt_code` varchar(100) NOT NULL,
  `is_wish` tinyint(1) NOT NULL,
  `coupon` varchar(1000) NOT NULL,
  ADD PRIMARY KEY (`plid`),
  ADD KEY `idx_uniacid` (`uniacid`),
  ADD KEY `idx_openid` (`openid`),
  ADD KEY `uniontid` (`uniontid`),
  ADD KEY `idx_tid` (`tid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
EOF;

}

if (!empty($setupSql)){
    pdo_query($setupSql);
}

if (!is_dir(MICRO_SERVER . "payment/cert/")){
    FileService::mkdirs(MICRO_SERVER . "payment/cert/");
}

$finish = true;
