<?php

namespace Server\sms;

use Illuminate\Support\Facades\DB;

use App\Services\MicroService;
use AlibabaCloud\SDK\Dysmsapi\V20170525\Dysmsapi;
use Darabonba\OpenApi\Models\Config;
use AlibabaCloud\SDK\Dysmsapi\V20170525\Models\SendSmsRequest;

class AliService {


    static function createClient($param){
        $config = new Config([
            "accessKeyId" => $param['accessKeyId'],
            "accessKeySecret" => $param['accessKeySecret']
        ]);
        $config->endpoint = "dysmsapi.aliyuncs.com";
        return  new Dysmsapi($config);
    }

    static function getConfig($uniacid){
        //获取配置
//        $setting = self::SettingLoad('sms',$uniacid);
        $resu =   DB::table('sms_setting')->where('uniacid',$uniacid)->first();
        $setting = !empty($resu['sms']) ? (array)unserialize($resu['sms']) : array();

        $res = array();
//        if($setting['sms']['ali_status'] != '1'){
        if($setting['ali_status'] != '1'){
            $res['error'] = 'false';
            $res['msg']  = '阿里云短信配置未开启，请先开启!';
            return $res;
        }
//        $accessKeyId = $setting['sms']['ali_accesskeyid'];
//        $accessKeySecret = $setting['sms']['ali_accesskeysecret'];
        $accessKeyId = $setting['ali_accesskeyid'];
        $accessKeySecret = $setting['ali_accesskeysecret'];

        if(empty($accessKeyId) || empty($accessKeySecret)){
            $res['error'] = 'false';
            $res['msg']  = '阿里云短信配置有误，请先修正后再试!';
            return $res;
        }

        $res['accessKeyId'] = $accessKeyId;
        $res['accessKeySecret'] = $accessKeySecret;
        return $res;
    }

    /**
     * 阿里云发送短信
     * @param array $template  短信模板
     * @param String $phoneNumbers  发送的手机号，多个以逗号隔开
     * @param array $params  模板变量及值
     * @return array 返回OK则成功，否则为失败原因
     */
    static function sendAliSMS($template,$phoneNumbers,$params=array()){
        $config = self::getConfig($template['uniacid']);
        if(!empty($config['error'])){
            $result['code'] = 'fail';
            $result['msg'] = $config['msg'];
            return $result;
        }
        $client = self::createClient($config);
        if($params){
            $templateParam = json_encode($params, JSON_UNESCAPED_UNICODE);
            $request_params = [
                'phoneNumbers'=>$phoneNumbers,
                'signName'=>$template['sign'],
                'templateCode'=>$template['template_id'],
                'templateParam'=>$templateParam
            ];
        }else{
            $request_params = [
                'phoneNumbers'=>$phoneNumbers,
                'signName'=>$template['sign'],
                'templateCode'=>$template['template_id']
            ];
        }
        $sendSmsRequest = new SendSmsRequest($request_params);
        $response = $client->sendSms($sendSmsRequest);
        $rep = $response->toMap();
        $result = [];
        //发送成功
        if($rep['body']['Code'] == 'OK'){
            $result['code'] = 'OK';
        }else{
            $result['code'] = 'fail';
        }
        $result['msg'] = $rep['body']['Message'];
        return $result;
    }



}
