<?php

namespace Server\sms;

use App\Services\MicroService;
use Illuminate\Support\Facades\DB;

// 导入对应产品模块的client
use TencentCloud\Sms\V20210111\SmsClient;
// 导入要请求接口对应的Request类
use TencentCloud\Sms\V20210111\Models\SendSmsRequest;
use TencentCloud\Common\Credential;
// 导入可选配置类
use TencentCloud\Common\Profile\ClientProfile;
use TencentCloud\Common\Profile\HttpProfile;


class TencentService extends MicroService {

    static function getConfig($uniacid){
        //获取配置
//        $setting = self::SettingLoad('sms',$uniacid);
        $resu =   DB::table('sms_setting')->where('uniacid',$uniacid)->first();
        $setting = !empty($resu['sms']) ? (array)unserialize($resu['sms']) : array();

        $res = array();
//        if($setting['sms']['tencent_status'] != '1'){
        if($setting['tencent_status'] != '1'){
            $res['error'] = 'false';
            $res['msg']  = '腾讯云短信配置未开启，请先开启!';
            return $res;
        }
//        $AppID = $setting['sms']['tencent_appid'];
//        $SecretId = $setting['sms']['tencent_secretid'];
//        $SecretKey = $setting['sms']['tencent_secretkey'];

        $AppID = $setting['tencent_appid'];
        $SecretId = $setting['tencent_secretid'];
        $SecretKey = $setting['tencent_secretkey'];

        if(empty($AppID) || empty($SecretId) || empty($SecretKey)){
            $res['error'] = 'false';
            $res['msg']  = '腾讯云短信必须配置项不能为空!';
            return $res;
        }

        $res['AppID'] = $AppID;
        $res['SecretId'] = $SecretId;
        $res['SecretKey'] = $SecretKey;
        return $res;
    }

    /**
     * 腾讯云发送短信
     * @param array $template  短信模板
     * @param string $phoneNumbers  发送的手机号，多个以逗号隔开
     * @param array $params  模板变量及值
     * @return array|String
     */
    static function sendTencentSMS($template,$phoneNumbers,$params=array()){
        $config = self::getConfig($template['uniacid']);
        if(!empty($config['error'])){
            return $config;
        }
        $cred = new Credential($config['SecretId'], $config['SecretKey']);
        // 实例化一个http选项，可选的，没有特殊需求可以跳过
        $httpProfile = new HttpProfile();
        // 配置代理（无需要直接忽略）
        // $httpProfile->setProxy("https://ip:port");
        $httpProfile->setReqMethod("GET");  // post请求(默认为post请求)
        $httpProfile->setReqTimeout(30);    // 请求超时时间，单位为秒(默认60秒)
        $httpProfile->setEndpoint("sms.tencentcloudapi.com");  // 指定接入地域域名(默认就近接入)
        $clientProfile = new ClientProfile();
        $clientProfile->setSignMethod("TC3-HMAC-SHA256");  // 指定签名算法(默认为HmacSHA256)
        $clientProfile->setHttpProfile($httpProfile);

        $client = new SmsClient($cred, "ap-guangzhou", $clientProfile);
        $req = new SendSmsRequest();
        $req->SmsSdkAppId = $config['AppID'];
        $req->SignName = $template['sign'];
        $req->TemplateId = $template['template_id'];

        if($params){
            $params = array_values($params);
            $req->TemplateParamSet = $params;
        }

//        $req->TemplateParamSet = array('1234','5');不带键名
        /* 下发手机号码，采用 E.164 标准，+[国家或地区码][手机号]
         * 示例如：+8613711112222， 其中前面有一个+号 ，86为国家码，13711112222为手机号，最多不要超过200个手机号*/
        $phoneNumbers = array_values(explode(',',$phoneNumbers));
        $req->PhoneNumberSet = $phoneNumbers;
        /* 用户的 session 内容（无需要可忽略）: 可以携带用户侧 ID 等上下文信息，server 会原样返回 */
        $req->SessionContext = "";
        /* 短信码号扩展号（无需要可忽略）: 默认未开通，如需开通请联系 [腾讯云短信小助手] */
        $req->ExtendCode = "";
        /* 国际/港澳台短信 SenderId（无需要可忽略）: 国内短信填空，默认未开通，如需开通请联系 [腾讯云短信小助手] */
        $req->SenderId = "";
        $result = ["code"=>"fail"];

        // 通过client对象调用SendSms方法发起请求。注意请求方法名与请求对象是对应的
        // 返回的resp是一个SendSmsResponse类的实例，与请求对象对应
        try {
            $resp = $client->SendSms($req);
        }catch (\Exception $exception){
            $result['msg'] = $exception->getMessage();
            return $result;
        }
        $res_json = $resp->toJsonString();
        $res_arr = json_decode($res_json,true);

        //发送成功
        if(is_array($res_arr['SendStatusSet'])){
            $failNum = 0;
            $successNum = 0;
            $msg = '';
            foreach ($res_arr['SendStatusSet'] as $val){
                if($val['Code'] != "Ok"){
                    $failNum = $failNum + 1;
                    $msg = $val['Message'];
                }else{
                    $successNum = $successNum + 1;
                }
            }
            if($failNum > 0){
                $result['msg'] = '发送成功'.$successNum.'条,失败'.$failNum.'条'.',失败原因：'.$msg;
            }else{
                $result['code'] = 'OK';
                $result['msg'] = '发送成功';
            }

        }else{
            $result['code'] = 'fail';
            $result = '发送失败';
        }
        return $result;
    }










}
