<?php

namespace Server\sms\web;

use Server\sms\SmsService;

/**
 * Class IndexController 短信模板管理
 */
class IndexController extends SmsService {

    /**
     * 获取短信模板列表
     */
    public function main(){
        global $_GPC;
        $return = array(
            "title" => "模板管理"
        );
        $condition = array();
        if(!empty($_GPC['keyword'])){
            $_GET['keyword'] = $condition['keyword'] = $_GPC['keyword'];
        }
        list($return['list'], $return['total'], $return['pager']) = $this->getList($condition, $_GPC['page']);
        $this->View($return);

    }



    /**
     * 新增短信模板
     */
    public function post(){
        global $_GPC;
        if (!empty($_GPC['uniacid'])){
            $this->uniacid = intval($_GPC['uniacid']);
        }
        if (checksubmit('savedata')){
            $data = $_GPC['data'];
            $data['provider'] = isset( $data['provider']) ? intval( $data['provider']) : 0;//服务商  0=阿里云 1=腾讯云
            if (empty($data['name'])) return error(-1,'模板名称不能为空');
            if (empty($data['template_id'])) return $this->error("模板ID/CODE不能为空");
            if (empty($data['sign'])) return $this->error("短信签名不能为空");
            $data['uniacid'] = $this->uniacid;
            $data['createtime'] = TIMESTAMP;
            $smsid = pdo_insertgetid($this->tables['sms'], $data);
            if ($smsid){
                return $this->success("添加成功！","refresh");
            }
            return $this->error("保存失败，请重试");
        }
        return $this->View(array('title'=>"添加新模板"));
    }

    /**
     * 短信模板详情
     */
    public function detail(){
        global $_GPC;
        $template = $this->getOne(intval($_GPC['id']));
        if (empty($template)) return $this->error("找不到该模板");
        return $this->View($template);
    }

    /**
     * 编辑短信模板
     */
    public function modify(){
        global $_GPC;
        $template = $this->getOne(intval($_GPC['id']));
        if (empty($template)) return $this->error("找不到该模板");
        $data = $_GPC['data'];
        if (empty($data['name'])) return $this->error("模板名称不能为空");
        if (!isset($data['provider'])) return $this->error("请选择服务商");
        if (empty($data['template_id'])) return $this->error("模板ID/CODE不能为空");
        if (empty($data['sign'])) return $this->error("短信签名不能为空");
        $data['updatetime'] = TIMESTAMP;
        if (!pdo_update($this->tables['sms'], $data, array('id'=>$_GPC['id']))){
            return $this->error("保存失败，请重试");
        }
        return $this->success("保存成功！","refresh");
    }


    /**
     * 删除模板
     */
    public function delete(){
        global $_GPC;
        if (!empty($_GPC['uniacid'])){
            $this->uniacid = intval($_GPC['uniacid']);
        }
        $id = $_GPC['id'] ? trim($_GPC['id']) : 'id';
        //查询单个
        $smsTemplate = pdo_get($this->tables['sms'],array('id'=>$id,'uniacid'=>$this->uniacid,'is_deleted'=>0));
        if(empty($smsTemplate)){
            return $this->error("删除失败，没有对应数据");
        }
        $updateNum = pdo_update($this->tables['sms'],array('is_deleted'=>1,'updatetime'=>TIMESTAMP),array('id'=>$smsTemplate['id']));
        if(!empty($updateNum) && $updateNum > 0){
            return $this->success("删除成功！","refresh");
        }
        return $this->error("删除失败，请重试");
    }

    /**
     * 短信设置
     */
    public function setting(){
        $this->Composer();
        global $_GPC;
        if (!empty($_GPC['uniacid'])){
            $this->uniacid = intval($_GPC['uniacid']);
        }
        if (checksubmit('savedata')){
            $params = $_GPC['data'];
            if($params['ali_status']==1){
                if(empty($params['ali_accesskeyid'])){
                    return $this->error("请输入阿里云AccessKeyId");
                }
                if(empty($params['ali_accesskeysecret'])){
                    return $this->error("请输入阿里云AccessSecret");
                }
            }
            if($params['tencent_status']==1){
                if(empty($params['tencent_appid'])){
                    return $this->error("腾讯云请输入AppID");
                }
                if(empty($params['tencent_secretid'])){
                    return $this->error("请输入腾讯云SecretId");
                }
                if(empty($params['tencent_secretkey'])){
                    return $this->error("请输入腾讯云SecretKey");
                }
            }
//            if (is_array($params)){
//                $params = serialize($params);
//            }
//            $complete = DB::table('sms_setting')->updateOrInsert(['uniacid'=>$this->uniacid],['sms'=>$params]);
//            var_dump($complete);die;

            $complete = $this->saveSmsConfig($this->uniacid,'sms',$params);
            if(!$complete){
                return $this->error("保存失败，请重试");
            }else{
                return $this->success("保存成功", "refresh");
            }


//            if (!$this->SettingSave('sms', $params,$this->uniacid)){
//                return $this->error("保存失败，请重试");
//            }
//            return $this->success("保存成功", "refresh");

        }
        return $this->View(array(
            'title'=>"短信设置",
            'template_list'=>$this->getList(array('uniacid'=>$this->uniacid,'is_deleted'=>0), -1,"list"),
//            'setting'=>$this->SettingLoad('sms',$this->uniacid)
            'setting'=>$this->getSmsConfig($this->uniacid)
        ));
    }

    /**
     * 测试发送短信页面
     */
    public function sendsmsdetail(){
        $this->Composer();
        global $_GPC;
        $template = $this->getOne(intval($_GPC['id']));
        if (empty($template)) return $this->error("找不到该模板");
        if (empty($template['content'])) return $this->error("未设置模板内容");
        $provider = intval($template['provider']);
        if ($provider==1){
            preg_match_all('/\{(\d+)\}/', $template['content'], $matches);
            if (!empty($matches[1])){
                foreach ($matches[1] as $key=>$value){
                    $str = '{' . $value . '}';
                    $html = '</div><div class="layui-input-inline"><input type="text" name="param[]" placeholder="输入变量值" required lay-verify="required" autocomplete="off" class="layui-input"></div><div class="layui-form-mid">';
                    $template['content'] = str_replace($str, $html, $template['content']);
                }
            }
        }else{
            preg_match_all('/\$\{(\w+)\}/', $template['content'], $matches);
            if (!empty($matches[1])){
                foreach ($matches[1] as $key=>$value){
                    $str = '${' . $value . '}';
                    $html = '</div><div class="layui-input-inline"><input type="text" name="param['.$value.']" placeholder="输入'.$value.'的值" required lay-verify="required" autocomplete="off" class="layui-input"></div><div class="layui-form-mid">';
                    $template['content'] = str_replace($str, $html, $template['content']);
                }
            }
        }
        $content = '<div class="layui-form-mid">'. $template['content'] .'</div>';
        $template['template_content'] = $content;
        return $this->View($template);
    }



    /**
     *  测试发送短信
     */
    public function testSendSms(){
        $this->Composer();
        global $_GPC;
        if (empty($_GPC['id'])) return $this->error("模板id不能为空");
        $template = $this->getOne(intval($_GPC['id']));
        if (empty($template)) return $this->error("找不到该模板");
        $data = $_GPC['data'];
        if (empty($data['PhoneNumbers'])) return $this->error("请输入接收短信手机号");
        $PhoneNumbers= preg_replace("/(\n)|(\s)|(\t)|(\')|(')|(，)/" ,',' ,$data['PhoneNumbers']);
        $params  = array();
        if (!empty($_GPC['param'])){
            $params = $_GPC['param'];
        }
        $res = $this->sendSms($PhoneNumbers,$_GPC['id'],$params);
        if($res===true){
            return $this->success("发送成功", "refresh");
        }else{
            return $this->error($res['message']);
        }

    }










}
