<?php

namespace Server\sso\library\signature;

class SignerVerifier
{
    // 密钥
    private $secretKey;

    public function __construct($secretKey) {
        $this->secretKey = $secretKey;
    }

    /**
     * 生成签名
     *
     * @param array $data 请求参数列表
     * @return string 生成的签名
     */
    public function createSignature($data) {
        // 对参数进行排序
        ksort($data);
        // 将参数连接起来
        $dataString = http_build_query($data, '', '&');
        // 使用HMAC-SHA256算法生成签名
        $signature = hash_hmac('sha256', $dataString, $this->secretKey, false);
        return $signature;
    }

    /**
     * 验证签名是否正确
     *
     * @param array $data 请求参数列表
     * @param string $givenSignature 客户端提供的签名
     * @return bool true表示签名一致；false表示签名不一致
     */
    public function verifySignature($data, $givenSignature) {
        // 对参数进行排序
        ksort($data);
        // 将参数连接起来
        $dataString = http_build_query($data, '', '&');
        // 使用HMAC-SHA256算法生成签名
        $expectedSignature = hash_hmac('sha256', $dataString, $this->secretKey, false);
        // 比较两个签名是否一致
        return ($expectedSignature === $givenSignature);
    }
}
