<?php

namespace Server\sso\web;

use Server\sso\SsoService;

class SettingController extends SsoService
{
    public function main(){
        global $_W;
        $setting=pdo_get('sso_setting',array('uniacid'=>$this->uniacid));
        //超管才有权限查看
        if($_W['isfounder']) $masterSecret=$this->getMasterSecret();

        $url=$_SERVER['REQUEST_SCHEME'] . '://' . $_SERVER['HTTP_HOST'];
        if($this->framework=='laravel'){
            $url.='/api/server/sso/auth/users';
        }else{
            $url.='/api/server.php?server=sso&ctrl=auth/users';
        }

        $results = array(
            "title"        => "基本信息",
            'setting'      => $setting,
            'masterSecret' => $masterSecret ?? '',
            'url'          => $url
        );

        $this->View($results);
    }
    public function save(){
        global $_GPC;

        $params = [
            'uniacid'=>$this->uniacid,
            'secret'  => $_GPC['secret'],
            'expire' => $_GPC['expire']
        ];
        if(empty($params['secret'])){
            return $this->error('请填写secret');
        }
        if(empty($params['expire'])){
            return $this->error('请填写code过期时间');
        }

        $where=array('uniacid'=>$params['uniacid']);
        $info=pdo_get('sso_setting',$where);
        if($info){
            $res=pdo_update('sso_setting',$params,$where);
        }else{
            $res=pdo_insert('sso_setting',$params);
        }
        if($res){
            return $this->success("保存成功", "refresh");
        }else{
            return $this->error('保存失败');
        }
    }
}
