<?php

namespace Server\storage;

use Qcloud\Cos\Client;
use OSS\OssClient;
use OSS\Core\OssException;

class RemoteService {

    static $alioss_citys = array('oss-cn-hangzhou'=>'杭州','oss-cn-shanghai'=>'上海','oss-cn-qingdao'=>'青岛','oss-cn-beijing'=>'北京','oss-cn-zhangjiakou'=>'张家口','oss-cn-huhehaote'=>'呼和浩特','oss-cn-wulanchabu'=>'乌兰察布','oss-cn-shenzhen'=>'深圳','oss-cn-heyuan'=>'河源','oss-cn-guangzhou'=>'广州','oss-cn-chengdu'=>'成都','oss-cn-hongkong'=>'香港','oss-us-west-1'=>'硅谷','oss-us-east-1'=>'弗吉尼亚','oss-ap-southeast-1'=>'新加坡','oss-ap-southeast-2'=>'悉尼','oss-ap-northeast-2'=>'首尔','oss-ap-southeast-3'=>'吉隆坡','oss-ap-northeast-1'=>'日本','oss-eu-central-1'=>'法兰克福','oss-me-east-1'=>'迪拜');

    static function alioss_upload($ossKey, $filePath, $setting=array(), $test=false){
        if (!file_exists($filePath)) return error(-1,'该文件不存在');
        if (empty($setting)) return error(-1,'未配置阿里云存储');
        if (empty($setting['bucket'])) return error(-1,'Bucket名称不正确');
        try {
            $accessKeyId = $setting['key'];
            $accessKeySecret = $setting['secret'];
            $endpoint = "https://{$setting['endpoint']}.aliyuncs.com";
            $bucket= $setting['bucket'];
            if (!empty($setting['internal'])){
                $endpoint = "https://{$setting['endpoint']}-internal.aliyuncs.com";
            }
            $ossClient = new OssClient($accessKeyId, $accessKeySecret, $endpoint);
            return $ossClient->uploadFile($bucket, $ossKey, $filePath);
        }catch (OssException $exception){
            return error(-1,$exception->getMessage());
        }
    }

    static function alioss_delete($ossKey, $setting=array()){
        if (empty($ossKey)){
            return error(-1,'无效的文件名');
        }
        if (empty($setting)){
            return error(-1,'未配置阿里云存储');
        }
        if (empty($setting['bucket'])) return error(-1,'Bucket名称不正确');
        try {
            $accessKeyId = $setting['key'];
            $accessKeySecret = $setting['secret'];
            $endpoint = "https://{$setting['endpoint']}.aliyuncs.com";
            $ossClient = new OssClient($accessKeyId, $accessKeySecret, $endpoint);
            return $ossClient->deleteObject($setting['bucket'], $ossKey);
        }catch (OssException $exception){
            return error(-1,$exception->getMessage());
        }
    }

    static function InitCos($remote=array()){
        global $_W;
        if (empty($remote)) $remote = $_W['setting']['remote']['cos'];
        if (!isset($_W['services']['cosv5'])){
            if (empty($remote) || empty($remote['appid']) || empty($remote['secretid']) || empty($remote['secretkey']) || empty($remote['local'])){
                return error(-1,'腾讯云存储配置未完善');
            }
            try {
                $cosClient = new Client(array('region' => $remote['local'],
                    'schema' => 'https',
                    'credentials'=> array(
                        'appId' => $remote['appid'],
                        'secretId'    => $remote['secretid'],
                        'secretKey' => $remote['secretkey'])));
                $_W['services']['cosv5'] = $cosClient;
            }catch (\Exception $exception){
                return error(-1,$exception->getMessage());
            }
        }
        return $_W['services']['cosv5'];
    }

    static function cos_upload($key,$setting=array(),$test=false){
        $filePath = ATTACHMENT_ROOT . $key;
        if ($test){
            $filePath = MICRO_SERVER . "storage/". $key;
        }
        if (!file_exists($filePath)) return error(-1,'该文件不存在');
        if (empty($setting)){
            return error(-1,'未配置腾讯云存储');
        }
        if (empty($setting['bucket'])) return error(-1,'Bucket名称不正确');
        try {
            $cosClient = self::InitCos($setting);
            if (is_error($cosClient)) return $cosClient;
            $result = $cosClient->putObject(array(
                'Bucket' => $setting['bucket'],
                'Key' =>  $key,
                'Body' => fopen($filePath, 'rb'),
                'ServerSideEncryption' => 'AES256'));
        }catch (\Exception $exception){
            return error(-1,$exception->getMessage());
        }
        return $result;
    }

    static function cos_delete($key, $setting=array()){
        if (empty($key)){
            return error(-1,'无效的文件名');
        }
        if (empty($setting)){
            return error(-1,'未配置腾讯云存储');
        }
        try {
            $cosClient = self::InitCos($setting);
            $result = $cosClient->deleteObject(array(
                'Bucket'=>$setting['bucket'],
                'Key'=>$key
            ));
        }catch (\Exception $exception){
            return error(-1,$exception->getMessage());
        }
        return $result;
    }

}
