<?php

use Illuminate\Support\Facades\Artisan;

$setupsql = "";

if (!pdo_tableexists('core_attachment')){
    $setupsql = <<<EOF
CREATE TABLE `ims_core_attachment` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) UNSIGNED NOT NULL,
  `uid` int(10) UNSIGNED NOT NULL,
  `filename` varchar(255) NOT NULL,
  `attachment` varchar(255) NOT NULL,
  `type` tinyint(3) UNSIGNED NOT NULL,
  `createtime` int(10) UNSIGNED NOT NULL,
  `module_upload_dir` varchar(100) NOT NULL,
  `group_id` int(11) NOT NULL,
  `displayorder` int(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `ims_attachment_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) NOT NULL,
  `name` varchar(25) NOT NULL,
  `uniacid` int(11) NOT NULL,
  `uid` int(11) NOT NULL,
  `type` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
EOF;

}else{

    if (!pdo_fieldexists("core_attachment", "module_name")){
        $setupsql.="ALTER TABLE ".tablename('core_attachment')." ADD `module_name` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '模块';";
        $setupsql.="ALTER TABLE ".tablename('attachment_group')." ADD `module_name` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '模块';";
    }
}

if (!empty($setupsql)){
    pdo_query($setupsql);
}

if (class_exists('Illuminate\Support\Facades\Artisan')){
    if (!is_dir(public_path('storage'))){
        Artisan::call('storage:link');
    }
}

$finish = true;
