<?php

namespace Server\storage\mobile;

use Server\storage\StorageService;

class IndexController extends StorageService
{

    public $accepts = array("file", "images", "audio", "video");

    public function main()
    {

    }

    public function uploader()
    {
        global $_GPC, $_W;
        if (!$this->checkAppLogin($_W['allow_r'])) {
            return $this->error("请先登录！");
        }
        if (!empty($_GPC['uniacid'])) {
            $this->uniacid = intval($_GPC['uniacid']);
        }
        if (checksubmit('inputname')) {
            $filename = $_GPC['inputname'] ? trim($_GPC['inputname']) : 'file';
            $type = !empty($_GPC['type'])?trim($_GPC['type']):'image';
            $complete = $this->putFile($filename, $type);
            if (is_error($complete)) return $complete;
            $fileParts = pathinfo($complete['name']);
            $attach = array(
                'uniacid' => $this->uniacid,
                'uid' => empty($_W[$_W['allow_r']]['id']) ? $_W['uid'] : $_W[$_W['allow_r']]['id'],
                'filename' => $fileParts['basename'],
                'attachment' => $complete['path'],
                'type' => $type,
                'createtime' => TIMESTAMP,
                'module_upload_dir' => "",
                'group_id' => 0,
                'displayorder' => 0,
                'module_name' => empty($_W['allow_r']) ? '' : $_W['allow_r']
            );
            $attachid = pdo_insertgetid($this->tables['attach'], $attach);
            if ($attachid) {
                if ($_GPC['frompage'] == 'picker') {
                    $attach['id'] = $attachid;
                    $attach['cover'] = $this->getCover($attach['attachment'], $type);
                    $attach['datetime'] = date('Y-m-d H:i', TIMESTAMP);
                    return $this->success($attach);
                }
                return $this->success("上传成功！", "refresh");
            }
        }
        return $this->error("上传失败，请重试");
    }

    public function picker()
    {
        global $_GPC, $_W;
        if (!$this->checkAppLogin($_W['allow_r'])) {
            return $this->error("请先登录！");
        }
        if (!empty($_GPC['uniacid'])) {
            $this->uniacid = intval($_GPC['uniacid']);
            $_GET['uniacid'] = $this->uniacid;
        }
        $type = isset($_GPC['type']) ? intval($_GPC['type']) : 1;
        $data = array('type' => $type, 'attach_types' => $this->attach_types);
        $data['uploadurl'] = $this->urlApp("uploader", array("type" => $type, "uniacid" => $this->uniacid, 'r' => str_replace('admin','',$_W['allow_r'])));
        $condition = array('type' => $type, 'groups' => array());
        if (isset($_GPC['gid'])) {
            $condition['group_id'] = intval($_GPC['gid']);
        }
        if ($type == 1) {
            $data['groups'] = $this->getGroups();
        }

        $data['accept'] = $this->accepts[$type];
        $where['type'] = $type;
        if (!empty($_W[$_W['allow_r']]['id'])) {
            $condition['uid'] = intval($_W[$_W['allow_r']]['id']);
            $condition['module_name'] = $_W['allow_r'];
            $where['uid'] = intval($_W[$_W['allow_r']]['id']);
            $where['module_name'] = $_W['allow_r'];
        }
        $data['total'] = $this->getList($where, -1, "total");
        $where['group_id'] = 0;
        $data['ungroups'] = $this->getList($where, -1, "total");
        list($data['list'], $data['counts'], $data['pager']) = $this->getList($condition, $_GPC['page']);
        $this->View($data);
    }

    public function checkAppLogin($app = '')
    {
        global $_W;
        if (empty($app)) {
            return false;
        }
        if (empty($_W[$app . 'id'])) {
            $cookie = json_decode(authcode(igetcookie('__' . $app . $_W['uniacid'] . 'session'), 'DECODE'), true);
            if (empty($cookie['id'])) {
                return false;
            } else {
                $_W[$app] = $cookie;
                $_W[$app . 'id'] = $cookie['id'];
                return true;
            }
        }
        return true;
    }
}
