<?php

namespace Server\storage\web;

use App\Services\FileService;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Storage;
use Server\storage\RemoteService;
use Server\storage\StorageService;

class IndexController extends StorageService {

    public $accepts = array("file","images","audio","video");

    public function main(){
        global $_GPC;
        $type = isset($_GPC['type']) ? intval($_GPC['type']) : 1;
        $data = array('title'=>"附件管理","groups"=>[],'attach_types'=>$this->attach_types, 'type'=>$type);
        $data['title'] .= " - ".$this->attach_types[$type];
        if ($type==1){
            $data['groups'] = $this->getGroups();
        }
        $upType = in_array($this->accept_type[$type], ['video', 'audio']) ? 'media' : $this->accept_type[$type];
        $acceptExts = $this->settings['upload'][$upType]['extentions'];
        $data['acceptExts'] = implode('|', $acceptExts);
        $condition = array('type'=>$type);
        if (isset($_GPC['gid'])){
            $condition['group_id'] = intval($_GPC['gid']);
        }
        $data['total'] = $this->getList(array('type'=>$type), -1, "total");
        $data['accept'] = $this->accepts[$type];
        $data['ungroups'] = $this->getList(array('type'=>$type,'group_id'=>0), -1, "total");
        list($data['list'], $data['counts'], $data['pager']) = $this->getList($condition, $_GPC['page']);
        $data['storageLink'] = true;
        $data['remoteForce'] = false;
        if ($this->framework=='laravel'){
            $storagePath = public_path('storage');
            if (!is_dir($storagePath)){
                Artisan::call('storage:link');
            }else{
                $readLink = $this->customReadlink($storagePath);
                if(!empty($readLink)){
                    if ($readLink==$storagePath){
                        $data['storageLink'] = false;
                    }
                }elseif(!is_link($storagePath)){
                    $data['storageLink'] = false;
                }
            }
            //强制要求开启云存储
            $data['remoteForce'] = env("APP_STORAGE_REMOTE", 0) && empty($this->settings['remote']['type']);
            $data['remoteState'] = $this->settings['remote']['type'];
        }
        $this->View($data);
    }

    public function customReadlink($symlink_path) {
        if (function_exists('readlink')){
            return readlink($symlink_path);
        }
        try {
            $iterator = new FilesystemIterator($symlink_path, FilesystemIterator::FOLLOW_SYMLINKS);
            return $iterator->getPathname();
        } catch (Exception $e) {
            return false; // 或者根据需要处理异常
        }
    }

    public function setting(){
        global $_GPC, $_W;
        if (!$_W['isfounder']) return $this->error("暂无权限");
        if ($_W['ispost']){
            $setting = $this->settings['upload'];
            if (isset($_GPC['image'])){
                $image = $_GPC['image'];
                $image['extentions'] = $image['extentions'] ? explode(',', str_replace("，",",",trim($image['extentions']))) : array();
                $image['limit'] = intval($image['limit']);
                $image['zip_percentage'] = intval($image['zip_percentage']);
                $setting['image'] = $image;
            }
            if (isset($_GPC['media'])){
                $media = $_GPC['media'];
                $media['extentions'] = $media['extentions'] ? explode(',', str_replace("，",",",trim($media['extentions']))) : array();
                $media['limit'] = intval($media['limit']);
                $setting['media'] = $media;
            }
            if (isset($_GPC['file'])){
                $file = $_GPC['file'];
                $file['extentions'] = $file['extentions'] ? explode(',', str_replace("，",",",trim($file['extentions']))) : array();
                $file['limit'] = intval($file['limit']);
                $setting['file'] = $file;
            }
            if (!$this->SettingSave('storage', $setting)){
                return $this->error("保存失败，请重试");
            }
            return $this->success("保存成功", "refresh");
        }
        return $this->View(array(
            'title'=>"上传设置",
            'setting'=>$this->settings['upload']
        ));
    }

    public function refactor(){
        global $_GPC;
        $name = trim($_GPC['name']);
        if (empty($name)) return $this->error("文件名不能为空");
        if (!pdo_update($this->tables['attach'], array('filename'=>$name), array('id'=>intval($_GPC['attachid'])))){
            return $this->error("保存失败，请重试");
        }
        return $this->success("保存成功", "refresh");
    }

    public function remove(){
        global $_GPC,$_W;
        if (!empty($this->uniacid) && empty($_W['isfounder']) && 'manager' != $_W['role'] && 'owner' != $_W['role']) {
            return $this->error("您没有权限删除文件");
        }
        if (checksubmit('multi')){
            $ids = $_GPC['ids'];
            if (empty($ids)) return $this->error("请选择要操作的文件");

            foreach ($ids as $id){
                $file = pdo_get($this->tables['attach'], array('id'=>intval($id),'uniacid'=>$this->uniacid), ['id', 'attachment']);
                if (empty($file)) continue;
                $complete = $this->removeFile($file['attachment']);
                if (is_error($complete)) continue;
                pdo_delete($this->tables['attach'], array('id'=>$file['id']));
            }

            return $this->success("删除成功", "refresh");
        }
        $file = pdo_get($this->tables['attach'], array('id'=>intval($_GPC['attachid']),'uniacid'=>$this->uniacid));
        if (!empty($file)){
            $complete = $this->removeFile($file['attachment']);
            if (is_error($complete)) return $complete;
            pdo_delete($this->tables['attach'], array('id'=>$file['id']));
        }
        return $this->success("删除成功", "refresh");
    }

    public function regroup(){
        global $_GPC;
        $gid = intval($_GPC['groupid']);
        if (checksubmit('multi')){
            $ids = $_GPC['ids'];
            if (empty($ids)) return $this->error("请选择要操作的文件");

            if (!pdo_query("UPDATE " . tablename($this->tables['attach']) . " SET `group_id`=$gid WHERE `id` IN (" . implode(",", $ids) . ")")){
                return $this->error("操作失败，请重试");
            }

            return $this->success("保存成功", "refresh");
        }
        $file = pdo_get($this->tables['attach'], array('id'=>intval($_GPC['attachid'])));
        if (empty($file)) return $this->error("找不到该文件");
        if (!pdo_update($this->tables['attach'], array('group_id'=>$gid), array('id'=>$file['id']))){
            return $this->error("保存失败，请重试");
        }
        return $this->success("保存成功", "refresh");
    }

    public function upload_remote(){
        global $_GPC;
        $fileType = 1;
        if (isset($_GPC['type'])){
            $fileType = intval($_GPC['type']);
        }
        $directory = $this->accepts[$fileType];
        if (!defined('QingFrame')){
            load()->func('file');
            $result = file_dir_remote_upload(ATTACHMENT_ROOT . $directory .'/' . $this->uniacid);
            if (is_error($result)){
                return $result;
            }
        }else{
            $allFiles = Storage::allFiles($directory . '/' . $this->uniacid);
            if (!empty($allFiles)){
                foreach ($allFiles as $item){
                    $res = $this->remoteUpload($item);
                    if (is_error($res)) continue;
                    @unlink(ATTACHMENT_ROOT . $item);
                }
            }
        }
        return $this->success("操作成功！", referer());
    }

    public function up2remote(){
        global $_GPC;
        if (checksubmit('multi')){
            $ids = $_GPC['ids'];
            if (empty($ids)) return $this->error("请选择要操作的文件");

            foreach ($ids as $id){
                $file = pdo_get($this->tables['attach'], array('id'=>intval($id),'uniacid'=>$this->uniacid), ['id', 'attachment']);
                if (empty($file)) continue;
                $localPath = ATTACHMENT_ROOT . $file['attachment'];
                if (!file_exists($localPath)) continue;
                $res = $this->remoteUpload($file['attachment']);
                if (is_error($res)) continue;
                @unlink($localPath);
            }

            return $this->success("操作成功", "refresh");
        }
        $file = pdo_get($this->tables['attach'], array('id'=>intval($_GPC['attachid']),'uniacid'=>$this->uniacid));
        if (empty($file)){
            return $this->error("找不到该文件");
        }
        $localPath = ATTACHMENT_ROOT . $file['attachment'];
        if (file_exists($localPath)){
            $res = $this->remoteUpload($file['attachment']);
            if (is_error($res)) return $res;
            //删除本地文件
            @unlink($localPath);
        }

        return $this->success("操作成功！", "refresh");
    }

    public function uploader(){
        global $_GPC, $_W;
        if (isset($_GPC['uniacid'])){
            $uniacid = intval($_GPC['uniacid']);
            if ($uniacid!=$this->uniacid){
                $this->uniacid = $uniacid;
                parent::__construct($uniacid);
            }
            $_GET['uniacid'] = $uniacid;
        }
        if (checksubmit('inputname')){
            $filename = $_GPC['inputname'] ? trim($_GPC['inputname']) : 'file';
            $disremote = (bool)$_GPC['disremote'];
            $type = isset($_GPC['type']) ? intval($_GPC['type']) : 1;
            $FileType = $this->accept_type[$type];
            $complete = $this->putFile($filename, $FileType, $disremote);
            if (is_error($complete)) return $complete;
            $fileParts = pathinfo($complete['name']);
            $attach = array(
                'uniacid'=>$this->uniacid,
                'uid'=>$_W['uid'],
                'filename'=>$fileParts['basename'],
                'attachment'=>$complete['path'],
                'type'=>$type,
                'createtime'=>TIMESTAMP,
                'module_upload_dir'=>"",
                'group_id'=>intval($_GPC['gid']),
                'displayorder'=>0
            );
            $attachid = pdo_insertgetid($this->tables['attach'], $attach);
            if ($attachid){
                if ($_GPC['frompage']=='picker'){
                    $attach['id'] = $attachid;
                    $attach['cover'] = $this->getCover($attach['attachment'], $type);
                    $attach['datetime'] = date('Y-m-d H:i', TIMESTAMP);
                    return $this->success($attach);
                }
                return $this->success("上传成功！","refresh");
            }
        }
        return $this->error("上传失败，请重试");
    }

    public function remote(){
        global $_W,$_GPC;
        $this->Composer();
        $isglobal = false;
        $remoteset = array('type'=>0);
        if (!empty($_GPC['uniacid'])){
            $this->uniacid = intval($_GPC['uniacid']);
        }
        if (!empty($this->uniacid)){
            $setting = $this->SettingLoad("remote", $this->uniacid);
            if (empty($_W['account']['uniacid'])){
                $_W['account'] = uni_fetch($this->uniacid);
            }
            if (!empty($setting['remote'])){
                $remoteset = $setting['remote'];
            }
        }
        if (!empty($_GPC['setglobal']) || empty($this->uniacid)){
            $settings = $this->SettingLoad("remote");
            if (!empty($settings['remote'])){
                $remoteset = $settings['remote'];
            }
            $isglobal = true;
        }
        if ($_W['ispost']){
            $attachs = array('','ftp','alioss','qiniu','cos','s3');
            $type = intval($_GPC['remotetype']);
            $type = isset($attachs[$type]) ? $type : 0;
            $method = $attachs[$type];
            $config = $remoteset;
            $config['type'] = $type;
            if (!empty($method)){
                $remote = $_GPC[$method];
                $testFile = MICRO_SERVER . "storage/remote.png";;
                if (empty($remote) && $type!=5) return $this->error('保存失败，请重试');
                if ($method=='alioss'){
                    $remote['endpoint'] = $_GPC['endpoint']?:'oss-cn-hangzhou';
                    if (!isset($remoteset['alioss']) || $remoteset['alioss']['key']!=$remote['key'] || $remoteset['alioss']['bucket']!=$remote['bucket'] || $remoteset['alioss']['secret']!=$remote['secret']){
                        $aliUpload = RemoteService::alioss_upload('remote.png',$testFile, $remote, true);
                        if (is_error($aliUpload)){
                            return $aliUpload;
                        }
                    }
                    if (empty($remote['url']) || $remoteset['alioss']['bucket']!=$remote['bucket']){
                        $remote['url'] = "https://{$remote['bucket']}.{$remote['endpoint']}.aliyuncs.com";
                    }
                    $config['alioss'] = $remote;
                }elseif ($method=='cos'){
                    if (empty($remote['appid']) || empty($remote['secretid']) || empty($remote['secretkey']) || empty($remote['bucket']) || empty($remote['local'])){
                        return $this->error('腾讯云存储配置未完善');
                    }
                    if(empty($remote['url'])){
                        $remote['url'] = sprintf('https://%s-%s.cos%s.myqcloud.com', trim($remote['bucket']), trim($remote['appid']), trim($remote['local']));
                    }
                    $defaultSet = (array)$_W['setting']['remote']['cos'];
                    if ($remote['appid']!=$defaultSet['appid'] || $remote['secretid']!=$defaultSet['secretid'] || $remote['secretkey']!=$defaultSet['secretkey'] || $remote['bucket']!=$defaultSet['bucket'] || $remote['local']!=$defaultSet['local'] || $remote['url']!=$defaultSet['url']){
                        $auth = RemoteService::cos_upload('remote.png',$remote,true);
                        if (is_error($auth)) {
                            return $this->error($auth['message']);
                        }
                    }
                    $config['cos'] = $remote;
                }elseif ($method=='s3'){
                    try {
                        $complete = Storage::disk('s3')->put('remote.png', file_get_contents($testFile));
                        if (is_error($complete)) return $complete;
                        if (!$complete) return $this->error("上传到S3失败，请先检查配置");
                    }catch (Exception $exception){
                        return $this->error($exception->getMessage());
                    }
                }
            }
            if ($isglobal){
                $complete = $this->SettingSave("remote", $config);
            }else{
                $complete = $this->SettingSave("remote", $config, $this->uniacid);
            }
            if ($complete){
                return $this->success("保存成功！","refresh");
            }
            return $this->error("保存失败，请重试");
        }
        $unsuport = array(1,3);
        if (!defined('QingFrame')){
            $unsuport[] = 5;
        }
        $data = array("title"=>"云存储", "isglobal"=>$isglobal,"unsuport"=>$unsuport,'uniacid'=>$this->uniacid);
        if (!empty($remoteset['alioss'])){
            $data['alicity'] = str_replace(".aliyuncs.com","", $remoteset['alioss']['ossurl']);
        }
        $data['setting'] = $remoteset;
        $data['attachs'] = array('关闭','FTP','阿里云存储','七牛云存储','腾讯云存储','亚马逊S3');
        $data['alicitys'] = RemoteService::$alioss_citys;
        return $this->View($data);
    }

    public function picker(){
        global $_GPC, $_W;
        if (isset($_GPC['uniacid'])){
            $uniacid = intval($_GPC['uniacid']);
            if ($uniacid!=$this->uniacid){
                $this->uniacid = $uniacid;
                parent::__construct($uniacid);
            }
            $_GET['uniacid'] = $_W['uniacid'] = $uniacid;
            if ($this->framework=='laravel'){
                $_W['attachurl'] = FileService::SetAttachUrl();
            }else{
                load()->model('attachment');
                $_W['attachurl'] = attachment_set_attach_url();
            }
        }
        if ($this->framework=='laravel'){
            $STORAGE_REMOTE = (bool)env("APP_STORAGE_REMOTE", 0);
            if ($STORAGE_REMOTE && !$this->settings['remote']['type']){
                return $this->message("请先配置云存储", $this->url("remote"));
            }
        }
        $type = isset($_GPC['type']) ? intval($_GPC['type']) : 1;
        $data = array('type'=>$type,'attach_types'=>$this->attach_types);
        $params = array("type"=>$type, "uniacid"=>$this->uniacid);
        if (isset($_GPC['disremote'])){
            $params['disremote'] = intval($_GPC['disremote']);
        }
        $data['uploadurl'] = $this->url("uploader", $params);
        $condition = array('type'=>$type,'groups'=>array());
        if (isset($_GPC['gid'])){
            $condition['group_id'] = intval($_GPC['gid']);
        }
        if ($type==1){
            $data['groups'] = $this->getGroups();
        }
        $data['accept'] = $this->accepts[$type];
        $upType = in_array($this->accept_type[$type], ['video', 'audio']) ? 'media' : $this->accept_type[$type];
        $acceptExts = $this->settings['upload'][$upType]['extentions'];
        $data['acceptExts'] = implode('|', $acceptExts);
        $data['total'] = $this->getList(array('type'=>$type), -1, "total");
        $data['ungroups'] = $this->getList(array('type'=>$type,'group_id'=>0), -1, "total");
        list($data['list'], $data['counts'], $data['pager']) = $this->getList($condition, $_GPC['page']);
        return $this->View($data);
    }

}
