<?php

namespace Server\ucenter;

class UcenterWiki {

    public static $credit_types = array('credit1','credit2','credit3','credit4','credit5','credit6');

    public static function Methods($data=array())
    {
        $methods = array();
        $methods['UpdateCredit'] = array(
            'name'=>"操作积分",
            "summary"=>"操作用户的积分增和减，会生成积分记录，并对用户做相应的操作（如等级提升等）",
            "params"=>array(
                "uid"=>["用户UID","int"],
                "type"=>["积分类型（".implode("、",self::$credit_types)."）","string|null"],
                "count"=>["操作金额，正数为加负数为减","float|int|null"],
                "params"=>["额外参数，包括等remark（备注）、store_id（门店ID）、clerk_id（店员ID）等","array|string|null"]
            ),
            "return"=>["修改结果","bool|error"]
        );
        $methods['ResetPassword'] = array(
            "name"=>"修改密码",
            "summary"=>"统一修改用户密码",
            "wiki"=>"",
            "params"=>array(
                "uid"=>["用户UID","int"],
                "password"=>["新密码","string"],
                "salt"=>["加密盐","string|null"]
            ),
            "return"=>["修改结果","bool|error"]
        );
        $methods['CheckUni'] = array(
            "name"=>"唯一性检测",
            "summary"=>"通过某一特征（如openid、手机号、邮箱）判断用户是否已注册，可以用来检测手机号/邮箱的占用情况",
            "params"=>array(
                "value"=>["检测词","string"],
                "field"=>["检查字段","string|null","mobile"]
            ),
            "return"=>["查询结果，如存在则返回UID","bool|int"]
        );
        $methods['UpdateInfo'] = array(
            "name"=>"更新资料",
            "summary"=>"更新用户资料",
            "params"=>array(
                "uid"=>["UID","int"],
                "profile"=>["用户资料数组，字段一一对应","array"]
            ),
            "return"=>["更新结果","bool|error"]
        );
        $methods['sendEmailCode'] = array(
            "name"=>"发送邮件验证码",
            "summary"=>"用于向用户发送邮件验证码",
            "params"=>array(
                "to"=>["接收者邮箱","string"],
                "code"=>["验证码","string"],
                "name"=>["平台名称","string|null"]
            ),
            "return"=>["发送结果","bool|error"]
        );
        $methods['tpl_form_user'] = array(
            "name"=>"用户选择器",
            "summary"=>"用于构造后台表单用户选择器",
            "params"=>array(
                "name"=>["输入框字段名(name)","string|null"],
                "value"=>["当前选中用户UID","int|null"],
                "options"=>["输入框属性，如placeholder、required等","array|null"]
            ),
            "return"=>["表单项HTML","string"]
        );
        return array_merge($methods, $data);
    }

}
