<?php

namespace Server\ucenter\api;

use Server\ucenter\UcenterService;

class LoginController extends UcenterService {

    public function main(){
        global $_GPC;
        $username = trim($_GPC['username']);
        $password = trim($_GPC['password']);
        $type = 'email';
        $verifyCode = trim($_GPC['code']);
        $verifyType = empty($_GPC['loginMode']) ? 'password' : trim($_GPC['loginMode']);
        if ($verifyType=="code"){
            if (empty($verifyCode)) return $this->error("请输入您收到的验证码");
        }elseif (empty($password)){
            return $this->error("登录密码不能为空");
        }
        if(preg_match($this->REGULAR_EMAIL, $username)){
            $userInfo = pdo_get($this->tables['member'], array("uniacid"=>$this->uniacid, "email"=>$username));
        }elseif (preg_match($this->REGULAR_MOBILE, $username)){
            $type = 'mobile';
            $userInfo = pdo_get($this->tables['member'], array("uniacid"=>$this->uniacid, "mobile"=>$username));
        }else{
            return $this->error("用户名格式不正确");
        }
        if (empty($userInfo)){
            return $this->error("找不到该用户");
        }
        if ($verifyType=="code"){
            $verifyRes = false;
            if ($type=="mobile"){
                //短信验证码
                $smsService = serv('sms');
                if ($smsService->enabled){
                    $res = $smsService->checkVerifyCode($username, $verifyCode);
                    if (!is_error($res)){
                        return $res;
                    }
                    $verifyRes = true;
                }
            }
            if (!$verifyRes){
                $res = pdo_get("uni_verifycode", array(
                    'uniacid' => $this->uniacid,
                    'receiver' => $username,
                    'verifycode' => $verifyCode,
                    'createtime >' => (TIMESTAMP - 1800)));
                if (empty($res)) return $this->error("验证码不正确");
                pdo_delete("uni_verifycode", array("receiver"=>$username, "uniacid"=>$this->uniacid));
            }
        }else{
            if (md5($password . $userInfo['salt'] . $this->authkey)!=$userInfo['password']){
                return $this->error("登录密码不正确");
            }
        }
        $token = $this->getToken($userInfo['uid'], $userInfo['password'], $userInfo['salt']);
        return $this->success(array(
            'uid'=>$userInfo['uid'],
            'groupid'=>$userInfo['groupid'],
            'token'=>$token,
            'nickname'=>$userInfo['nickname'],
            'avatar'=>$this->avatar($userInfo['uid'], $userInfo['avatar'])
        ));
    }

}
