<?php

namespace Server\ucenter\api;

use Server\ucenter\UcenterService;

class RegisterController extends UcenterService {

    public function main(){
        global $_GPC;
        $password = trim($_GPC['password']);
        if (empty($password)) return $this->error("密码不能为空");
        $pwdLen = strlen($password);
        if ($pwdLen<6){
            return $this->error("密码不能为空");
        }
        $profile = array();
        if (!empty($_GPC['profile'])){
            $profile = $this->getProfile($_GPC['profile']);
        }
        $userInfo = $this->register($_GPC['username'], $password, $profile);
        if (is_error($userInfo)){
            return $this->error($userInfo['message'], $userInfo['errno']);
        }
        $token = $this->getToken($userInfo['uid'], $userInfo['password'], $userInfo['salt']);
        return $this->success(array(
            'uid'=>$userInfo['uid'],
            'groupid'=>$userInfo['groupid'],
            'token'=>$token,
            'nickname'=>$userInfo['nickname'],
            'avatar'=>$this->avatar($userInfo['uid'], $userInfo['avatar'])
        ));
    }

    public function getProfile($userinfo=array()){
        return array(
            'nickname'=>$userinfo['nickName'],
            'gender'=>$userinfo['gender'],
            'avatar'=>$userinfo['avatarUrl'],
            'resideprovince'=>$userinfo['province'],
            'residecity'=>$userinfo['city'],
            'nationality'=>$userinfo['country']
        );
    }

}
