# Ucenter 微服务数据库安装和升级说明

## 概述
Ucenter 微服务包含完整的用户中心功能，包括用户管理、积分系统、用户组管理等。本文档说明数据库的安装和升级逻辑。

## 数据库表结构

### 1. mc_members (用户表)
存储用户基本信息和积分余额。

**主要字段：**
- `uid`: 用户ID (主键)
- `uniacid`: 统一账号ID
- `mobile`: 手机号
- `email`: 邮箱
- `password`: 密码
- `salt`: 密码盐
- `groupid`: 用户组ID
- `credit1` - `credit6`: 6种积分类型
- `createtime`: 创建时间
- `nickname`: 昵称
- `avatar`: 头像
- `api_token`: API访问令牌

### 2. mc_groups (用户组表)
存储用户组信息。

**主要字段：**
- `groupid`: 用户组ID (主键)
- `uniacid`: 统一账号ID
- `title`: 用户组名称
- `credit`: 所需积分
- `price`: 价格
- `paytype`: 支付类型
- `isdefault`: 是否默认组

### 3. mc_member_fields (用户字段表)
存储用户自定义字段配置。

**主要字段：**
- `id`: 记录ID (主键)
- `uniacid`: 统一账号ID
- `name`: 字段名称
- `fieldid`: 字段ID
- `title`: 字段标题
- `available`: 是否可用
- `displayorder`: 显示顺序

### 4. mc_credits_record (积分记录表)
存储用户积分变动记录。

**主要字段：**
- `id`: 记录ID (主键)
- `uid`: 用户ID
- `uniacid`: 统一账号ID
- `credittype`: 积分类型
- `num`: 变动数量
- `balance_after`: 变动后的账户余额 ⭐
- `operator`: 操作员ID
- `module`: 模块标识
- `clerk_id`: 店员ID
- `store_id`: 门店ID
- `clerk_type`: 店员类型
- `createtime`: 创建时间
- `remark`: 备注说明
- `real_uniacid`: 真实统一账号ID

## 安装逻辑 (install.php)

### 执行条件
- 微服务首次安装时执行
- 检查表是否存在，不存在则创建

### 创建的表
1. **mc_members**: 用户表
2. **mc_groups**: 用户组表  
3. **mc_member_fields**: 用户字段表
4. **mc_credits_record**: 积分记录表 (包含 balance_after 字段)

### 特点
- 完整的表结构创建
- 包含所有必要的索引
- 支持新的 balance_after 字段
- 使用 MyISAM 引擎和 UTF8 字符集

## 升级逻辑 (upgrade.php)

### 执行条件
- 微服务升级时执行
- 检查字段是否存在，不存在则添加

### 升级内容

#### 1. 字段检查和添加
- `mc_member_fields.name`: 字段名称
- `mc_members.api_token`: API访问令牌
- `mc_credits_record.balance_after`: 积分变动后余额 ⭐

#### 2. 数据填充
当 `balance_after` 字段存在但有空值时，自动计算并填充：

**算法逻辑：**
1. 按用户ID、积分类型、时间顺序获取所有记录
2. 为每个用户每种积分类型维护余额计数器
3. 逐条计算每条记录变动后的余额
4. 更新记录的 `balance_after` 字段

**示例：**
```php
// 用户 123 的 credit1 积分变动记录
// 初始余额: 0
// 记录1: +100 -> balance_after = 100
// 记录2: -20  -> balance_after = 80  
// 记录3: +50  -> balance_after = 130
```

## 微服务独立性

### 优势
1. **独立安装**: 不依赖主系统的数据库迁移
2. **自动升级**: 检测并添加新字段
3. **数据完整性**: 自动填充历史数据
4. **向后兼容**: 支持旧版本数据

### 安装流程
1. 检查表是否存在
2. 不存在则创建完整表结构
3. 存在则检查并添加缺失字段
4. 填充历史数据（如需要）

### 升级流程
1. 检查新字段是否存在
2. 不存在则添加字段
3. 检查数据完整性
4. 自动填充缺失数据

## 使用示例

### 安装微服务
```php
// 在微服务安装时调用
include_once 'install.php';
```

### 升级微服务
```php
// 在微服务升级时调用
include_once 'upgrade.php';
```

### 验证安装
```sql
-- 检查表是否存在
SHOW TABLES LIKE 'mc_credits_record';

-- 检查字段是否存在
DESCRIBE mc_credits_record;

-- 检查数据是否填充
SELECT uid, credittype, num, balance_after, createtime 
FROM mc_credits_record 
WHERE balance_after IS NOT NULL 
ORDER BY uid, credittype, createtime 
LIMIT 10;
```

## 注意事项

1. **备份数据**: 升级前建议备份数据库
2. **测试环境**: 建议先在测试环境验证
3. **性能考虑**: 数据填充可能耗时，建议在低峰期执行
4. **错误处理**: 升级脚本包含错误处理机制
5. **版本兼容**: 支持从任意版本升级到最新版本

## 版本历史

- **v1.0**: 基础用户管理功能
- **v1.1**: 添加 API 令牌支持
- **v1.2**: 添加积分记录表
- **v1.3**: 添加余额记录功能 ⭐

---

⭐ 表示新增功能 