<?php

namespace Server\ucenter\web;

use Server\ucenter\UcenterService;

class CreditController extends UcenterService {

    public function main(){
        global $_GPC;
        $credits = $this->getSetting('creditnames');
        $credit = empty($_GPC['type']) ? 'credit2' : trim($_GPC['type']);
        if (!isset($credits[$credit])) return error(-1, "无效的积分类型");
        if (!$credits[$credit]['enabled']) return error(-1, "暂未开放此类积分交易");
        $condition = array('type'=>$credit);
        $member = null;
        if(!empty($_GPC['uid'])){
            $member = $this->getUser($_GPC['uid']);
            if(empty($member)) return error("找不到该用户");
            $condition['uid'] = $member['uid'];
            if ($_GPC['inajax']){
                $condition['pagesize'] = 8;
            }
        }
        $return = array(
            'title'=>"积分记录",
            'member'=>$member,
            'credits'=>$credits,
            'credit'=>$credit,
            'increment'=>0,
            'decrement'=>0,
            'unit'=>$credit=='credit1'?'积分':'元'
        );
        list($return['list'], $return['total'], $return['pager'], $return['sum'], $return['increment'], $return['decrement']) = $this->getCreditRecord($condition,$_GPC['page']);
        return $this->View($return);
    }

    public function setting(){
        $setting = $this->getSetting();
        $creditnames = array();
        if (empty($setting['creditnames'])) return error(-1,"暂无可用选项");
        foreach ($setting['creditnames'] as $key=>$value){
            $value['activity'] = $setting['creditbehaviors']['activity'] == $key;
            $value['currency'] = $setting['creditbehaviors']['currency'] == $key;
            $value['disabled'] = ($key=='credit1'||$key=='credit2');
            $value['title'] = $value['title'] ? : $key;
            $creditnames[$key] = $value;
        }
        return $this->View(array('title'=>"积分策略", 'creditnames'=>$creditnames));
    }

    public function post(){
        global $_GPC;
        if (checksubmit()){
            $setting = $this->getSetting();
            $credit = trim($_GPC['credit']);
            if (!isset($setting['creditnames'][$credit])){
                return error(-1,"无效的积分标识");
            }
            $setting['creditnames'][$credit]['title'] = trim($_GPC['title']);
            if(empty($setting['creditnames'][$credit]['title'])) return error(-1, "积分名称不能为空");
            $complete = $this->SettingSave('creditnames', $setting['creditnames'], $this->uniacid);
            if ($complete) message("修改成功","","success");
        }
        return error(-1,"操作失败");
    }

    public function modify(){
        global $_GPC;
        if(checksubmit()){
            $setting = $this->getSetting();
            $credit = trim($_GPC['credit']);
            if (!isset($setting['creditnames'][$credit])){
                return error(-1,"无效的积分标识");
            }
            $modify = trim($_GPC['modify']);
            $complete = false;
            switch ($modify){
                case "currency":
                case "activity" : {
                    $setting['creditbehaviors'][$modify] = $credit;
                    $complete = $this->SettingSave("creditbehaviors", $setting['creditbehaviors'], $this->uniacid);
                    break;
                }
                case "checkout" : {
                    $setting['creditnames'][$credit]['enabled'] = intval($_GPC['value']);
                    $complete = $this->SettingSave('creditnames', $setting['creditnames'], $this->uniacid);
                    break;
                }
                default : break;
            }
            if ($complete) message("操作成功","","success");
        }
        return error(-1,"操作失败");
    }

}
