<?php

namespace Server\ucenter\web;

use Server\ucenter\UcenterService;

class GroupController extends UcenterService {

    public function main(){
        $this->View(array(
            'title'=>'用户组',
            'groups'=>$this->setting['groups'],
            'grouplevel'=>$this->setting['grouplevel'],
            'paytypes'=>['月','季','年']
        ));
    }

    public function remove(){
        global $_GPC;
        $group = $this->getGroup($_GPC['groupid']);
        if (!$group) return $this->error('找不到该用户组');
        if ($group['isdefault']) return $this->error('默认等级不可删除');
        $complete = $this->removeGroup($group);
        if (!$complete) return $this->error('删除失败，请重试');
        return $this->success('删除成功！','refresh');
    }

    public function post(){
        global $_GPC;
        $setting = $this->getSetting();
        if ($_GPC['groupid']){
            $group = $this->getGroup($_GPC['groupid']);
        }
        if(checksubmit('savedata')){
            $upgradefault = false;
            $data = $_GPC['data'];
            $data['isdefault'] = intval($data['isdefault']);
            $data['credit'] = intval($data['credit']);
            $data['price'] = floatval($data['price']);
            if ($data['isdefault']){
                if (!$group['isdefault']){
                    $this->UpdateGroup(array('isdefault'=>0),array('isdefault'=>1));
                }
            }elseif($group['isdefault']){
                $upgradefault = true;
            }
            if ($group){
                $complete = $this->UpdateGroup($data, $group['groupid']);
            }else{
                $complete = $this->UpdateGroup($data);
            }
            if (!$complete) return $this->error('保存失败，请重试');
            if ($upgradefault){
                $this->SetGroupDefault();
            }
            return $this->success('保存成功！','refresh');
        }
        return $this->View(array(
            'title'=>$group?'编辑用户组-'.$group['title']:'新增用户组',
            'group'=>$group,
            'grouplevel'=>intval($setting['grouplevel'])
        ));
    }

}
