<?php

namespace Server\ucenter\web;

use Server\ucenter\UcenterService;

class MemberController extends UcenterService {

    public function main(){
        global $_GPC;
        $return = array(
            "title" => "用户管理"
        );
        $condition = array();
        if(!empty($_GPC['groupid'])){
            $condition['groupid'] = $_GPC['groupid'];
            $_GET['groupid'] = $_GPC['groupid'];
        }
        if(!empty($_GPC['keyword'])){
            $_GET['keyword'] = $condition['keyword'] = $_GPC['keyword'];
        }
        list($return['list'], $return['total'], $return['pager']) = $this->getUsers($condition, $_GPC['page']);
        $this->View($return);
    }

    public function charge(){
        global $_GPC;
        if (checksubmit()){
            $type = trim($_GPC['type']);
            $amount = floatval($_GPC['amount']);
            $remark = "后台手动充值{$amount}".($type=='credit2'?'元':'积分');
            $complete = $this->UpdateCredit(intval($_GPC['uid']), $type, $amount, array('remark'=>$remark));
            if (is_error($complete)) return $complete;
            return $this->success("操作成功");
        }
        return $this->error("操作失败，请重试");
    }

    public function modify(){
        global $_GPC;
        $users = $this->getUser(intval($_GPC['uid']));
        if (empty($users)) return $this->error("找不到该用户");
        if (!empty($_GPC['password'])){
            $password = trim($_GPC['password']);
            $repwd = $this->ResetPassword($users['uid'], $password);
            if (is_error($repwd)) return $repwd;
        }
        $data = $_GPC['data'];
        if (empty($data['avatar'])) return $this->error("用户头像不能为空");
        if (empty($data['nickname'])) return $this->error("用户昵称不能为空");
        if (empty($data['mobile']) && empty($data['email'])){
            return $this->error("手机号和邮箱不能同时为空");
        }
        if (!empty($_GPC['birthday'])){
            list($data['birthyear'], $data['birthmonth'], $data['birthday']) = explode("-", trim($_GPC['birthday']));
        }
        $complete = $this->UpdateInfo($users['uid'], $data);
        if (is_error($complete) && !isset($repwd)){
            return $complete;
        }
        return $this->success("保存成功！","refresh");
    }

    public function picker(){
        global $_GPC;
        $condition = array("keyword"=>trim($_GPC['keyword']));
        $uid = intval($_GPC['uid']);
        $html = "";
        $users = $this->getUsers($condition, -1, "list");
        if (!empty($users)){
            foreach ($users as $value){
                $selected = $uid==$value['uid'] ? ' class="layui-select-tips layui-this"' : '';
                $nickname = $value['nickname']?: "用户".$value['uid'];
                $html .= '<dd data-uid="'.$value['uid'].'" data-nick="'.$nickname.'" data-avatar="'.$value['avatar'].'"'.$selected.'>'.$nickname.'(UID:'.$value['uid'].')</dd>';
            }
        }
        echo $html;
        exit();
    }

    public function detail(){
        global $_GPC;
        $users = $this->getUser(intval($_GPC['uid']));
        if (empty($users)) return $this->error("找不到该用户");
        return $this->View(array(
            'title'=>$users['nickname'],
            'avatar'=>$this->avatar($users['uid'], $users['avatar']),
            'group'=>$this->getGroup($users['groupid']),
            'member'=>$users,
            'groups'=>$this->setting['groups']
        ));
    }

    public function remove(){
        global $_GPC;
        if ($this->cancellation($_GPC['uid'])){
            return $this->success("删除成功！","refresh");
        }
        return $this->error("操作失败，请重试");
    }

    public function post(){
        global $_GPC;
        if (checksubmit('savedata')){
            $profile = $_GPC['profile'];
            $password = trim($_GPC['password']);
            $repassword = trim($_GPC['repassword']);
            if (empty($profile['nickname'])) return error(-1,'用户昵称不能为空');
            $namelen = mb_strlen($profile['nickname'],'utf-8');
            if ($namelen<1 || $namelen>15) return error(-1,'昵称长度不正确(1~15)');
            if (empty($profile['mobile']) && empty($profile['email'])){
                return error(-1,'手机号和邮箱必填其一');
            }
            if (!empty($profile['mobile'])){
                if(!preg_match($this->REGULAR_MOBILE, $profile['mobile'])){
                    return error(-1,'手机号格式不正确');
                }
                if($this->CheckUni($profile['mobile'], 'mobile')){
                    return error(-1,'该手机号码已被注册');
                }
            }
            if (!empty($profile['email'])){
                if(!preg_match($this->REGULAR_EMAIL, $profile['email'])){
                    return error(-1,'邮箱号格式不正确');
                }
                if($this->CheckUni($profile['email'], 'email')){
                    return error(-1,'该手机号码已被注册');
                }
            }

            $username = $profile['mobile'];
            if (empty($username)){
                $username = $profile['email'];
            }
            if (empty($password)) return error(-1,'登录密码不能为空');
            if (empty($repassword)) return error(-1,'请输入确认密码');
            if ($repassword!=$password) return error(-1,'两次输入的密码不一致');
            $complete = $this->register($username,$password,$profile);
            if (is_error($complete)) return $complete;
            message('保存成功！', $this->url('member'), 'success');
        }
        return $this->View(array('title'=>"添加新用户"));
    }

}
