<?php

namespace Server\unipush\web;

use Server\unipush\UnipushService;

class IndexController extends UnipushService {

    public function main(){
        return $this->View([
            'title'=>"推送设置",
            'configs'=>$this->configs
        ],'setting');
    }

    public function setting(){
        if (checksubmit()){
            $config = pdo_get("unipush", array('uniacid'=>$this->uniacid));
            global $_GPC;
            if (!empty($_GPC['unipush'])){
                $unipush = $_GPC['unipush'];
                $unipush['switch'] = (bool)intval($unipush['switch']);
            }else{
                $unipush = $this->configs['unipush'];
            }
            if (!empty($_GPC['jpush'])){
                $jpush = $_GPC['jpush'];
                $jpush['switch'] = (bool)intval($jpush['switch']);
                $jpush['debugMode'] = intval($jpush['debugMode']);
            }else{
                $jpush = $this->configs['jpush'];
            }
            if (!empty($config)){
                pdo_update("unipush", array(
                    "unipush"=>serialize($unipush),
                    "jpush"=>serialize($jpush),
                    "dateline"=>TIMESTAMP
                ), array('uniacid'=>$this->uniacid));
            }else{
                pdo_insert("unipush",array(
                    "uniacid"=>$this->uniacid,
                    "unipush"=>serialize($unipush),
                    "jpush"=>serialize($jpush),
                    "addtime"=>TIMESTAMP,
                    "dateline"=>TIMESTAMP
                ));
            }
            return $this->success("保存成功！", referer());
        }
        return $this->error("操作失败！请重试");
    }

}
