<?php

use App\Services\FileService;
use Illuminate\Support\Facades\DB;

//插入默认设置表
$socketSet = serialize(array(
    'type'=>'remote',
    'server'=>'wss://socket.whotalk.com.cn/wss',
    'api'=>'https://socket.whotalk.com.cn/api/message/sendMessageToUser'
));
DB::table("microserver_data")->updateOrInsert(array('name'=>'swasocket'), array('data'=>$socketSet, 'uniacid'=>0, 'dateline'=>TIMESTAMP));

//解压socket文件夹
$zipFile = MICRO_SERVER . 'websocket/swasocket.zip';
$installed = file_exists(MICRO_SERVER . 'websocket/installed.bin');

if (file_exists($zipFile) && !$installed){
    //清空文件夹
    if (is_dir(base_path('swasocket'))){
        @FileService::rmdirs(base_path('swasocket'), true);
    }else{
        FileService::mkdirs(base_path('swasocket'));
    }

    //解压文件
    $zip = new \ZipArchive();
    $openRes = $zip->open($zipFile);
    if ($openRes === TRUE) {
        $zip->extractTo(base_path('swasocket'));
        $zip->close();
        //新增安装文件
        file_put_contents(MICRO_SERVER . 'websocket/installed.bin', TIMESTAMP);
    }else{
        $zip->close();
    }
}

if (!DEVELOPMENT){
    @unlink(MICRO_SERVER."websocket/install.php");
}

$finish = true;
